/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.util.Arrays;
import java.util.List;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.filter.sqlmm.SpatialFunction;
import org.apache.sis.internal.geoapi.filter.Literal;
import org.apache.sis.internal.geoapi.filter.ValueReference;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class TwoGeometries<R, G>
extends SpatialFunction<R> {
    private static final long serialVersionUID = -5209470632171445234L;
    final Expression<? super R, GeometryWrapper<G>> geometry1;
    final Expression<? super R, GeometryWrapper<G>> geometry2;

    TwoGeometries(SQLMM sQLMM, Expression<? super R, ?>[] expressionArray, Geometries<G> geometries) {
        super(sQLMM, expressionArray);
        this.geometry1 = TwoGeometries.toGeometryWrapper(geometries, expressionArray[0]);
        this.geometry2 = TwoGeometries.toGeometryWrapper(geometries, expressionArray[1]);
    }

    @Override
    public Expression<R, Object> recreate(Expression<? super R, ?>[] expressionArray) {
        return new TwoGeometries(this.operation, expressionArray, this.getGeometryLibrary());
    }

    @Override
    public Expression<? super R, ?> optimize(Optimization optimization) {
        Expression<? super R, ?> expression;
        DefaultFeatureType defaultFeatureType = optimization.getFeatureType();
        if (defaultFeatureType != null && (expression = TwoGeometries.unwrap(this.geometry1)) instanceof ValueReference && TwoGeometries.unwrap(this.geometry2) instanceof Literal) {
            try {
                GeometryWrapper<G> geometryWrapper;
                GeometryWrapper<G> geometryWrapper2;
                CoordinateReferenceSystem coordinateReferenceSystem = AttributeConvention.getCRSCharacteristic(defaultFeatureType, defaultFeatureType.getProperty(((ValueReference)expression).getXPath()));
                if (coordinateReferenceSystem != null && (geometryWrapper2 = this.geometry2.apply((Object)null)) != null && (geometryWrapper = geometryWrapper2.transform(coordinateReferenceSystem)) != geometryWrapper2) {
                    Expression[] expressionArray = this.getParameters().toArray(new Expression[0]);
                    expressionArray[1] = Optimization.literal(geometryWrapper);
                    return this.recreate(expressionArray);
                }
            }
            catch (IllegalArgumentException | TransformException exception) {
                this.warning(exception, true);
            }
        }
        return super.optimize(optimization);
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return TwoGeometries.getGeometryLibrary(this.geometry1);
    }

    @Override
    public List<Expression<? super R, ?>> getParameters() {
        return Arrays.asList(TwoGeometries.unwrap(this.geometry1), TwoGeometries.unwrap(this.geometry2));
    }

    @Override
    public Object apply(R r) {
        GeometryWrapper<G> geometryWrapper;
        GeometryWrapper<G> geometryWrapper2 = this.geometry1.apply(r);
        if (geometryWrapper2 != null && (geometryWrapper = this.geometry2.apply(r)) != null) {
            try {
                return geometryWrapper2.operation(this.operation, geometryWrapper);
            }
            catch (RuntimeException | TransformException exception) {
                this.warning(exception, false);
            }
        }
        return null;
    }

    static final class WithArgument<R, G>
    extends TwoGeometries<R, G> {
        private static final long serialVersionUID = -121819663224041806L;
        final Expression<? super R, ?> argument;

        WithArgument(SQLMM sQLMM, Expression<? super R, ?>[] expressionArray, Geometries<G> geometries) {
            super(sQLMM, expressionArray, geometries);
            this.argument = expressionArray[2];
        }

        @Override
        public Expression<R, Object> recreate(Expression<? super R, ?>[] expressionArray) {
            return new WithArgument(this.operation, expressionArray, this.getGeometryLibrary());
        }

        @Override
        public List<Expression<? super R, ?>> getParameters() {
            return Arrays.asList(WithArgument.unwrap(this.geometry1), WithArgument.unwrap(this.geometry2), this.argument);
        }

        @Override
        public Object apply(R r) {
            GeometryWrapper geometryWrapper;
            GeometryWrapper geometryWrapper2 = (GeometryWrapper)this.geometry1.apply(r);
            if (geometryWrapper2 != null && (geometryWrapper = (GeometryWrapper)this.geometry2.apply(r)) != null) {
                try {
                    return geometryWrapper2.operationWithArgument(this.operation, geometryWrapper, this.argument.apply(r));
                }
                catch (RuntimeException | TransformException exception) {
                    this.warning(exception, false);
                }
            }
            return null;
        }
    }
}

