/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.isoline;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.sis.internal.processing.isoline.Fragments;
import org.apache.sis.internal.processing.isoline.Joiner;
import org.apache.sis.internal.processing.isoline.PolylineBuffer;
import org.apache.sis.internal.processing.isoline.PolylineStage;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class Tracer {
    static final int UPPER_LEFT = 1;
    static final int UPPER_RIGHT = 2;
    static final int LOWER_LEFT = 4;
    static final int LOWER_RIGHT = 8;
    private final double[] window;
    private final int pixelStride;
    int x;
    int y;
    private final double translateX;
    private final double translateY;
    private final MathTransform gridToCRS;

    Tracer(double[] dArray, int n, Rectangle rectangle, MathTransform mathTransform) {
        this.window = dArray;
        this.pixelStride = n;
        this.translateX = rectangle.x;
        this.translateY = rectangle.y;
        this.gridToCRS = mathTransform;
    }

    private Joiner writeTo(Joiner joiner, PolylineBuffer[] polylineBufferArray, boolean bl) throws TransformException {
        for (int i = 0; i < polylineBufferArray.length; ++i) {
            PolylineBuffer polylineBuffer = polylineBufferArray[i];
            if (polylineBuffer == null) continue;
            int n = polylineBuffer.size;
            if (n == 0) {
                assert (polylineBuffer.isEmpty());
                continue;
            }
            if (joiner == null) {
                joiner = new Joiner(this.gridToCRS);
            }
            joiner.append(polylineBuffer.coordinates, n, (i & 1) == 0);
            polylineBuffer.clear();
        }
        if (joiner != null) {
            joiner.createPolyline(bl);
        }
        return joiner;
    }

    final class Level {
        private final int band;
        final double value;
        int isDataAbove;
        private final PolylineBuffer polylineOnLeft;
        private final PolylineBuffer[] polylinesOnTop;
        private final Map<Point, Fragments> partialPaths;
        private Joiner path;
        Shape shape;

        Level(int n, double d, int n2) {
            this.band = n;
            this.value = d;
            this.partialPaths = new HashMap<Point, Fragments>();
            this.polylineOnLeft = new PolylineBuffer();
            this.polylinesOnTop = new PolylineBuffer[n2];
            for (int i = 0; i < n2; ++i) {
                this.polylinesOnTop[i] = new PolylineBuffer();
            }
        }

        final void nextColumn() {
            this.isDataAbove = (this.isDataAbove & 0xA) >>> 1;
        }

        final void interpolate() throws TransformException {
            switch (this.isDataAbove) {
                default: {
                    throw new AssertionError(this.isDataAbove);
                }
                case 0: 
                case 15: {
                    assert (this.polylinesOnTop[Tracer.this.x].isEmpty());
                    assert (this.polylineOnLeft.isEmpty());
                    break;
                }
                case 3: 
                case 12: {
                    assert (this.polylinesOnTop[Tracer.this.x].isEmpty());
                    this.interpolateMissingLeftSide();
                    this.interpolateOnRightSide();
                    break;
                }
                case 5: 
                case 10: {
                    assert (this.polylineOnLeft.isEmpty());
                    PolylineBuffer polylineBuffer = this.polylinesOnTop[Tracer.this.x];
                    this.interpolateMissingTopSide(polylineBuffer);
                    this.interpolateOnBottomSide(polylineBuffer);
                    break;
                }
                case 4: 
                case 11: {
                    assert (this.polylinesOnTop[Tracer.this.x].isEmpty());
                    this.interpolateMissingLeftSide();
                    this.interpolateOnBottomSide(this.polylinesOnTop[Tracer.this.x].transferFrom(this.polylineOnLeft));
                    break;
                }
                case 2: 
                case 13: {
                    assert (this.polylineOnLeft.isEmpty());
                    this.interpolateMissingTopSide(this.polylineOnLeft.transferFrom(this.polylinesOnTop[Tracer.this.x]));
                    this.interpolateOnRightSide();
                    break;
                }
                case 7: 
                case 8: {
                    assert (this.polylinesOnTop[Tracer.this.x].isEmpty());
                    assert (this.polylineOnLeft.isEmpty());
                    this.interpolateOnRightSide();
                    this.interpolateOnBottomSide(this.polylinesOnTop[Tracer.this.x].attach(this.polylineOnLeft));
                    break;
                }
                case 1: 
                case 14: {
                    this.closeLeftWithTop(this.polylinesOnTop[Tracer.this.x]);
                    break;
                }
                case 6: 
                case 9: {
                    double d = 0.0;
                    double[] dArray = Tracer.this.window;
                    int n = this.band;
                    do {
                        d += dArray[n];
                    } while ((n += Tracer.this.pixelStride) < dArray.length);
                    assert ((n -= this.band) == Tracer.this.pixelStride * 4) : n;
                    boolean bl = this.isDataAbove == 6;
                    boolean bl2 = (d /= 4.0) <= this.value;
                    PolylineBuffer polylineBuffer = this.polylinesOnTop[Tracer.this.x];
                    if (bl ^= bl2) {
                        this.closeLeftWithTop(polylineBuffer);
                        this.interpolateOnRightSide();
                        this.interpolateOnBottomSide(polylineBuffer.attach(this.polylineOnLeft));
                        break;
                    }
                    this.interpolateMissingLeftSide();
                    PolylineBuffer polylineBuffer2 = new PolylineBuffer().transferFrom(polylineBuffer);
                    this.interpolateOnBottomSide(polylineBuffer.transferFrom(this.polylineOnLeft));
                    this.interpolateMissingTopSide(this.polylineOnLeft.transferFrom(polylineBuffer2));
                    this.interpolateOnRightSide();
                    break;
                }
            }
        }

        private void interpolateMissingLeftSide() {
            if (this.polylineOnLeft.size == 0) {
                this.polylineOnLeft.append(Tracer.this.translateX + (double)Tracer.this.x, Tracer.this.translateY + ((double)Tracer.this.y + this.interpolate(0, 2 * Tracer.this.pixelStride)));
            }
        }

        private void interpolateMissingTopSide(PolylineBuffer polylineBuffer) {
            if (polylineBuffer.size == 0) {
                this.interpolateOnTopSide(polylineBuffer);
            }
        }

        private void interpolateOnTopSide(PolylineBuffer polylineBuffer) {
            polylineBuffer.append(Tracer.this.translateX + ((double)Tracer.this.x + this.interpolate(0, Tracer.this.pixelStride)), Tracer.this.translateY + (double)Tracer.this.y);
        }

        private void interpolateOnRightSide() {
            this.polylineOnLeft.append(Tracer.this.translateX + (double)(Tracer.this.x + 1), Tracer.this.translateY + ((double)Tracer.this.y + this.interpolate(Tracer.this.pixelStride, 3 * Tracer.this.pixelStride)));
        }

        private void interpolateOnBottomSide(PolylineBuffer polylineBuffer) {
            polylineBuffer.append(Tracer.this.translateX + ((double)Tracer.this.x + this.interpolate(2 * Tracer.this.pixelStride, 3 * Tracer.this.pixelStride)), Tracer.this.translateY + (double)(Tracer.this.y + 1));
        }

        private double interpolate(int n, int n2) {
            double[] dArray = Tracer.this.window;
            int n3 = this.band;
            double d = dArray[n3 + n];
            double d2 = dArray[n3 + n2];
            return (this.value - d) / (d2 - d);
        }

        private void closeLeftWithTop(PolylineBuffer polylineBuffer) throws TransformException {
            PolylineBuffer[] polylineBufferArray;
            this.interpolateMissingLeftSide();
            this.interpolateMissingTopSide(polylineBuffer);
            if (this.polylineOnLeft.opposite == polylineBuffer) {
                assert (polylineBuffer.opposite == this.polylineOnLeft);
                polylineBufferArray = new PolylineBuffer[]{polylineBuffer, this.polylineOnLeft};
            } else {
                Fragments fragments = new Fragments(this.polylineOnLeft, polylineBuffer);
                if (fragments.isEmpty()) {
                    polylineBufferArray = new PolylineBuffer[]{this.polylineOnLeft.opposite, this.polylineOnLeft, polylineBuffer, polylineBuffer.opposite};
                } else if (fragments.addOrMerge(this.partialPaths)) {
                    polylineBufferArray = fragments.toPolylines();
                } else {
                    return;
                }
            }
            this.path = Tracer.this.writeTo(this.path, polylineBufferArray, true);
        }

        private void writeFragment(PolylineBuffer polylineBuffer) throws TransformException {
            PolylineBuffer[] polylineBufferArray;
            boolean bl;
            Fragments fragments = new Fragments(polylineBuffer, null);
            if (fragments.isEmpty()) {
                bl = false;
                polylineBufferArray = new PolylineBuffer[]{polylineBuffer.opposite, polylineBuffer};
            } else {
                bl = fragments.addOrMerge(this.partialPaths);
                if (!bl) {
                    return;
                }
                polylineBufferArray = fragments.toPolylines();
            }
            this.path = Tracer.this.writeTo(this.path, polylineBufferArray, bl);
        }

        final void finishedRow() throws TransformException {
            if (!this.polylineOnLeft.transferToOpposite()) {
                this.writeFragment(this.polylineOnLeft);
            }
            this.isDataAbove = 0;
        }

        final void finish() throws TransformException {
            assert (this.polylineOnLeft.isEmpty());
            this.polylineOnLeft.coordinates = null;
            for (int i = 0; i < this.polylinesOnTop.length; ++i) {
                this.writeFragment(this.polylinesOnTop[i]);
                this.polylinesOnTop[i] = null;
            }
            assert (this.isConsistent());
        }

        private boolean isConsistent() {
            for (Map.Entry<Point, Fragments> entry : this.partialPaths.entrySet()) {
                if (entry.getValue().isExtremity(entry.getKey())) continue;
                return false;
            }
            return true;
        }

        final void merge(Level level) throws TransformException {
            assert (level != this && level.value == this.value);
            if (this.path == null) {
                this.path = level.path;
            } else {
                this.path.append(level.path);
            }
            level.path = null;
            assert (this.isConsistent());
            assert (level.isConsistent());
            IdentityHashMap<Fragments, Boolean> identityHashMap = new IdentityHashMap<Fragments, Boolean>(level.partialPaths.size() / 2);
            for (Map.Entry<Point, Fragments> entry : level.partialPaths.entrySet()) {
                Fragments fragments = entry.getValue();
                if (identityHashMap.put(fragments, Boolean.TRUE) == null) {
                    assert (fragments.isExtremity(entry.getKey()));
                    if (fragments.addOrMerge(this.partialPaths)) {
                        this.path = Tracer.this.writeTo(this.path, fragments.toPolylines(), true);
                        fragments.clear();
                    }
                }
                entry.setValue(null);
            }
        }

        final void flush() throws TransformException {
            for (Map.Entry<Point, Fragments> entry : this.partialPaths.entrySet()) {
                Fragments fragments = entry.getValue();
                assert (fragments.isExtremity(entry.getKey()));
                if (!fragments.isEmpty()) {
                    this.path = Tracer.this.writeTo(this.path, fragments.toPolylines(), false);
                    fragments.clear();
                }
                entry.setValue(null);
            }
            if (this.path != null) {
                this.shape = this.path.build();
                this.path = null;
            }
        }

        final void toRawPath(Map<PolylineStage, Path2D> map) {
            PolylineStage.FINAL.add(map, this.path != null ? this.path.snapshot() : this.shape);
            PolylineStage.FRAGMENT.add(map, this.partialPaths);
            this.polylineOnLeft.toRawPath(map);
            for (PolylineBuffer polylineBuffer : this.polylinesOnTop) {
                if (polylineBuffer == null) continue;
                polylineBuffer.toRawPath(map);
            }
        }
    }
}

