/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.internal.storage.WritableResourceSupport;
import org.apache.sis.internal.storage.esri.AsciiGridStore;
import org.apache.sis.internal.storage.esri.AsciiGridStoreProvider;
import org.apache.sis.internal.storage.io.ChannelDataOutput;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.IncompatibleResourceException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.StringBuilders;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class WritableStore
extends AsciiGridStore
implements WritableGridCoverageResource {
    private final String lineSeparator = System.lineSeparator();
    private ChannelDataOutput output;

    public WritableStore(AsciiGridStoreProvider asciiGridStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super(asciiGridStoreProvider, storageConnector, false);
        if (!super.canReadOrWrite(false)) {
            this.output = storageConnector.commit(ChannelDataOutput.class, "ASCII Grid");
        }
    }

    @Override
    boolean canReadOrWrite(boolean bl) {
        return bl || super.canReadOrWrite(bl);
    }

    private static double distanceFromIntegers(MathTransform mathTransform) throws TransformException {
        Matrix matrix = MathTransforms.getMatrix(mathTransform.inverse());
        if (matrix != null && Matrices.isAffine(matrix)) {
            int n = matrix.getNumCol() - 1;
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                double d2 = matrix.getElement(i, n);
                d += Math.abs(Math.rint(d2) - d2);
            }
            return d;
        }
        return Double.NaN;
    }

    private static SequenceType getAffineCoefficients(Map<String, Object> map, GridGeometry gridGeometry, WritableResourceSupport writableResourceSupport) throws DataStoreException {
        Object object;
        String string = "XLLCORNER";
        String string2 = "YLLCORNER";
        MathTransform mathTransform = gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER);
        try {
            object = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
            if (WritableStore.distanceFromIntegers((MathTransform)object) < WritableStore.distanceFromIntegers(mathTransform)) {
                mathTransform = object;
                string = "XLLCENTER";
                string2 = "YLLCENTER";
            }
        }
        catch (TransformException transformException) {
            throw new DataStoreReferencingException(writableResourceSupport.canNotWrite(), transformException);
        }
        object = writableResourceSupport.getAffineTransform2D(gridGeometry.getExtent(), mathTransform);
        if (((AffineTransform)object).getShearX() != 0.0 || ((AffineTransform)object).getShearY() != 0.0) {
            throw new IncompatibleResourceException(writableResourceSupport.rotationNotSupported("ASCII Grid"));
        }
        double d = ((AffineTransform)object).getScaleX();
        double d2 = -((AffineTransform)object).getScaleY();
        double d3 = ((AffineTransform)object).getTranslateX();
        double d4 = ((AffineTransform)object).getTranslateY();
        if (!(d > 0.0) || !(d2 > 0.0)) {
            throw new IncompatibleResourceException(writableResourceSupport.canNotWrite());
        }
        map.put(string, d3);
        map.put(string2, d4 -= d2 * (double)((Integer)map.get("NROWS")).intValue());
        if (d == d2) {
            map.put("CELLSIZE", d);
        } else {
            map.put(CELLSIZES[0], d);
            map.put(CELLSIZES[1], d2);
        }
        return SequenceType.LINEAR;
    }

    private void writeHeader(Map<String, Object> map, ChannelDataOutput channelDataOutput) throws IOException {
        String string;
        int n = 0;
        int n2 = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            string = entry.getValue().toString();
            entry.setValue(string);
            n2 = Math.max(n2, string.length());
            n = Math.max(n, entry.getKey().length());
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            string = entry.getKey();
            WritableStore.write(string, channelDataOutput);
            WritableStore.write(CharSequences.spaces(n - string.length() + 1), channelDataOutput);
            string = (String)entry.getValue();
            WritableStore.write(CharSequences.spaces(n2 - string.length()), channelDataOutput);
            WritableStore.write(string, channelDataOutput);
            WritableStore.write(this.lineSeparator, channelDataOutput);
        }
    }

    @Override
    public synchronized void write(GridCoverage gridCoverage, WritableGridCoverageResource.Option ... optionArray) throws DataStoreException {
        WritableResourceSupport writableResourceSupport = new WritableResourceSupport(this, optionArray);
        try {
            int n;
            if (this.output == null && !writableResourceSupport.replace(this.input().input)) {
                gridCoverage = writableResourceSupport.update(gridCoverage);
            }
            RenderedImage renderedImage = gridCoverage.render(null);
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("NCOLS", renderedImage.getWidth());
            linkedHashMap.put("NROWS", renderedImage.getHeight());
            SequenceType sequenceType = WritableStore.getAffineCoefficients(linkedHashMap, gridCoverage.getGridGeometry(), writableResourceSupport);
            ChannelDataOutput channelDataOutput = this.output != null ? this.output : writableResourceSupport.channel(this.input().input);
            Number number = this.setCoverage(gridCoverage, renderedImage, 0);
            linkedHashMap.put("NODATA_VALUE", number);
            this.writeHeader(linkedHashMap, channelDataOutput);
            float f = number.floatValue();
            double d = number.doubleValue();
            StringBuilder stringBuilder = new StringBuilder();
            PixelIterator pixelIterator = new PixelIterator.Builder().setIteratorOrder(sequenceType).create(renderedImage);
            int n2 = pixelIterator.getDataType().toDataBufferType();
            int n3 = n = pixelIterator.getDomain().width;
            while (pixelIterator.next()) {
                switch (n2) {
                    case 5: {
                        double d2 = pixelIterator.getSampleDouble(0);
                        if (Double.isNaN(d2)) {
                            d2 = d;
                        }
                        stringBuilder.append(d2);
                        StringBuilders.trimFractionalPart(stringBuilder);
                        break;
                    }
                    case 4: {
                        float f2 = pixelIterator.getSampleFloat(0);
                        if (Float.isNaN(f2)) {
                            f2 = f;
                        }
                        stringBuilder.append(f2);
                        StringBuilders.trimFractionalPart(stringBuilder);
                        break;
                    }
                    default: {
                        stringBuilder.append(pixelIterator.getSample(0));
                    }
                }
                WritableStore.write(stringBuilder, channelDataOutput);
                stringBuilder.setLength(0);
                if (--n3 != 0) {
                    channelDataOutput.writeByte(32);
                    continue;
                }
                WritableStore.write(this.lineSeparator, channelDataOutput);
                n3 = n;
            }
            channelDataOutput.flush();
            this.writePRJ();
            if (this.output != null) {
                this.output = null;
                channelDataOutput.channel.close();
            }
        }
        catch (IOException iOException) {
            this.closeOnError(iOException);
            throw new DataStoreException(iOException);
        }
    }

    private static void write(CharSequence charSequence, ChannelDataOutput channelDataOutput) throws IOException {
        int n = charSequence.length();
        channelDataOutput.ensureBufferAccepts(n);
        for (int i = 0; i < n; ++i) {
            channelDataOutput.buffer.put((byte)charSequence.charAt(i));
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        ChannelDataOutput channelDataOutput = this.output;
        this.output = null;
        if (channelDataOutput != null) {
            try {
                channelDataOutput.channel.close();
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
        super.close();
    }
}

