/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.util.FactoryException;

final class EllipsoidalHeightSeparator
implements AxisFilter {
    private final GeodeticDatum datum;
    private final boolean vertical;

    EllipsoidalHeightSeparator(GeodeticDatum geodeticDatum, boolean bl) {
        this.datum = geodeticDatum;
        this.vertical = bl;
    }

    @Override
    public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
        return AxisDirections.isVertical(coordinateSystemAxis.getDirection()) == this.vertical;
    }

    private static CRSFactory factory() {
        return DefaultFactories.forBuildin(CRSFactory.class);
    }

    SingleCRS separate(SingleCRS singleCRS) throws FactoryException {
        CoordinateSystem coordinateSystem = CoordinateSystems.replaceAxes(singleCRS.getCoordinateSystem(), this);
        if (this.vertical) {
            VerticalCRS verticalCRS = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            if (!Utilities.equalsIgnoreMetadata(verticalCRS.getCoordinateSystem(), coordinateSystem)) {
                verticalCRS = EllipsoidalHeightSeparator.factory().createVerticalCRS(ReferencingUtilities.getPropertiesForModifiedCRS(verticalCRS), verticalCRS.getDatum(), (VerticalCS)coordinateSystem);
            }
            return verticalCRS;
        }
        if (singleCRS instanceof GeodeticCRS) {
            CommonCRS commonCRS;
            if (!(coordinateSystem instanceof EllipsoidalCS)) {
                throw new IllegalArgumentException(Errors.format((short)178, IdentifiedObjects.getName(coordinateSystem, null)));
            }
            CommonCRS commonCRS2 = CommonCRS.WGS84;
            if (Utilities.equalsIgnoreMetadata(commonCRS2.geographic().getCoordinateSystem(), coordinateSystem)) {
                CommonCRS commonCRS3 = CommonCRS.forDatum(this.datum);
                if (commonCRS3 != null) {
                    return commonCRS3.geographic();
                }
            } else if (Utilities.equalsIgnoreMetadata(commonCRS2.normalizedGeographic().getCoordinateSystem(), coordinateSystem) && (commonCRS = CommonCRS.forDatum(this.datum)) != null) {
                return commonCRS.normalizedGeographic();
            }
            return EllipsoidalHeightSeparator.factory().createGeographicCRS(ReferencingUtilities.getPropertiesForModifiedCRS(singleCRS), this.datum, (EllipsoidalCS)coordinateSystem);
        }
        if (singleCRS instanceof ProjectedCRS) {
            GeographicCRS geographicCRS = ((ProjectedCRS)singleCRS).getBaseCRS();
            if (ReferencingUtilities.getDimension(geographicCRS) != 2) {
                geographicCRS = (GeographicCRS)this.separate(geographicCRS);
            }
            Conversion conversion = ((ProjectedCRS)singleCRS).getConversionFromBase();
            conversion = new DefaultConversion(ReferencingUtilities.getPropertiesForModifiedCRS(conversion), conversion.getMethod(), null, conversion.getParameterValues());
            return EllipsoidalHeightSeparator.factory().createProjectedCRS(ReferencingUtilities.getPropertiesForModifiedCRS(singleCRS), geographicCRS, conversion, (CartesianCS)coordinateSystem);
        }
        throw new IllegalArgumentException(Errors.format((short)163, singleCRS.getClass()));
    }
}

