/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import opennlp.tools.util.StringUtil;

public class NGramCharModel
implements Iterable<String> {
    protected static final String COUNT = "count";
    private final Map<String, Integer> mNGrams = new HashMap<String, Integer>();

    public int getCount(String ngram) {
        Integer count = this.mNGrams.get(ngram);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public void setCount(String ngram, int count) {
        Integer oldCount = this.mNGrams.put(ngram, count);
        if (oldCount == null) {
            this.mNGrams.remove(ngram);
            throw new NoSuchElementException();
        }
    }

    public void add(String ngram) {
        if (this.contains(ngram)) {
            this.setCount(ngram, this.getCount(ngram) + 1);
        } else {
            this.mNGrams.put(ngram, 1);
        }
    }

    public void add(CharSequence chars, int minLength, int maxLength) {
        for (int lengthIndex = minLength; lengthIndex < maxLength + 1; ++lengthIndex) {
            int textIndex = 0;
            while (textIndex + lengthIndex - 1 < chars.length()) {
                String gram = StringUtil.toLowerCase(chars.subSequence(textIndex, textIndex + lengthIndex));
                this.add(gram);
                ++textIndex;
            }
        }
    }

    public void remove(String ngram) {
        this.mNGrams.remove(ngram);
    }

    public boolean contains(String ngram) {
        return this.mNGrams.containsKey(ngram);
    }

    public int size() {
        return this.mNGrams.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.mNGrams.keySet().iterator();
    }

    public int numberOfGrams() {
        int counter = 0;
        for (String ngram : this) {
            counter += this.getCount(ngram);
        }
        return counter;
    }

    public void cutoff(int cutoffUnder, int cutoffOver) {
        if (cutoffUnder > 0 || cutoffOver < Integer.MAX_VALUE) {
            Iterator<String> it = this.iterator();
            while (it.hasNext()) {
                String ngram = it.next();
                int count = this.getCount(ngram);
                if (count >= cutoffUnder && count <= cutoffOver) continue;
                it.remove();
            }
        }
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj == this) {
            result = true;
        } else if (obj instanceof NGramCharModel) {
            NGramCharModel model = (NGramCharModel)obj;
            result = this.mNGrams.equals(model.mNGrams);
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        return "Size: " + this.size();
    }

    public int hashCode() {
        return this.mNGrams.hashCode();
    }
}

