/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.batch;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tika.batch.FileResourceConsumer;
import org.apache.tika.eval.app.AbstractProfiler;
import org.apache.tika.eval.app.ExtractComparer;
import org.apache.tika.eval.app.batch.DBConsumersManager;
import org.apache.tika.eval.app.batch.EvalConsumerBuilder;
import org.apache.tika.eval.app.db.TableInfo;
import org.apache.tika.util.PropsUtil;

public class ExtractComparerBuilder
extends EvalConsumerBuilder {
    public static final String TABLE_PREFIX_A_KEY = "tablePrefixA";
    public static final String TABLE_PREFIX_B_KEY = "tablePrefixB";
    private final List<TableInfo> tableInfosA;
    private final List<TableInfo> tableInfosB;
    private final List<TableInfo> tableInfosAandB;
    private final List<TableInfo> refTableInfos;

    public ExtractComparerBuilder() {
        ArrayList<TableInfo> tableInfosA = new ArrayList<TableInfo>();
        ArrayList<TableInfo> tableInfosB = new ArrayList<TableInfo>();
        ArrayList<TableInfo> tableInfosAandB = new ArrayList<TableInfo>();
        tableInfosA.add(ExtractComparer.PROFILES_A);
        tableInfosA.add(ExtractComparer.EXCEPTION_TABLE_A);
        tableInfosA.add(ExtractComparer.TAGS_TABLE_A);
        tableInfosA.add(ExtractComparer.CONTENTS_TABLE_A);
        tableInfosA.add(ExtractComparer.EXTRACT_EXCEPTION_TABLE_A);
        tableInfosA.add(ExtractComparer.EMBEDDED_FILE_PATH_TABLE_A);
        tableInfosB.add(ExtractComparer.PROFILES_B);
        tableInfosB.add(ExtractComparer.EXCEPTION_TABLE_B);
        tableInfosB.add(ExtractComparer.EXTRACT_EXCEPTION_TABLE_B);
        tableInfosB.add(ExtractComparer.TAGS_TABLE_B);
        tableInfosB.add(ExtractComparer.CONTENTS_TABLE_B);
        tableInfosB.add(ExtractComparer.EMBEDDED_FILE_PATH_TABLE_B);
        tableInfosAandB.add(ExtractComparer.COMPARISON_CONTAINERS);
        tableInfosAandB.add(ExtractComparer.CONTENT_COMPARISONS);
        tableInfosAandB.add(AbstractProfiler.MIME_TABLE);
        ArrayList<TableInfo> refTableInfos = new ArrayList<TableInfo>();
        refTableInfos.add(ExtractComparer.REF_PAIR_NAMES);
        refTableInfos.add(AbstractProfiler.REF_PARSE_ERROR_TYPES);
        refTableInfos.add(AbstractProfiler.REF_PARSE_EXCEPTION_TYPES);
        refTableInfos.add(AbstractProfiler.REF_EXTRACT_EXCEPTION_TYPES);
        this.tableInfosA = Collections.unmodifiableList(tableInfosA);
        this.tableInfosB = Collections.unmodifiableList(tableInfosB);
        this.tableInfosAandB = Collections.unmodifiableList(tableInfosAandB);
        this.refTableInfos = Collections.unmodifiableList(refTableInfos);
    }

    @Override
    public FileResourceConsumer build() throws IOException, SQLException {
        Path extractsA = PropsUtil.getPath((String)this.localAttrs.get("extractsA"), null);
        if (extractsA == null) {
            throw new RuntimeException("Must specify \"extractsA\" -- directory for 'A' extracts");
        }
        Path extractsB = PropsUtil.getPath((String)this.localAttrs.get("extractsB"), null);
        if (extractsB == null) {
            throw new RuntimeException("Must specify \"extractsB\" -- directory for 'B' extracts");
        }
        Path inputRootDir = PropsUtil.getPath((String)this.localAttrs.get("inputDir"), null);
        if (inputRootDir == null) {
            throw new RuntimeException("Must specify an -inputDir");
        }
        return this.parameterizeProfiler(new ExtractComparer(this.queue, inputRootDir, extractsA, extractsB, this.buildExtractReader(this.localAttrs), this.getDBWriter(this.getNonRefTableInfos())));
    }

    @Override
    protected void updateTableInfosWithPrefixes(Map<String, String> attrs) {
        String tablePrefixA = (String)this.localAttrs.get(TABLE_PREFIX_A_KEY);
        String tablePrefixB = (String)this.localAttrs.get(TABLE_PREFIX_B_KEY);
        tablePrefixA = tablePrefixA == null || tablePrefixA.endsWith("_") ? tablePrefixA : tablePrefixA + "_";
        String string = tablePrefixB = tablePrefixB == null || tablePrefixB.endsWith("_") ? tablePrefixB : tablePrefixB + "_";
        if (tablePrefixA != null) {
            for (TableInfo tableInfo : this.tableInfosA) {
                tableInfo.setNamePrefix(tablePrefixA);
            }
        }
        if (tablePrefixB != null) {
            for (TableInfo tableInfo : this.tableInfosB) {
                tableInfo.setNamePrefix(tablePrefixB);
            }
        }
        if (tablePrefixA != null || tablePrefixB != null) {
            String aAndB = tablePrefixA == null ? "" : tablePrefixA;
            aAndB = tablePrefixB == null ? aAndB : aAndB + tablePrefixB;
            for (TableInfo tableInfo : this.tableInfosAandB) {
                tableInfo.setNamePrefix(aAndB);
            }
        }
    }

    @Override
    protected List<TableInfo> getRefTableInfos() {
        return this.refTableInfos;
    }

    @Override
    protected List<TableInfo> getNonRefTableInfos() {
        ArrayList<TableInfo> allNonRefTables = new ArrayList<TableInfo>();
        allNonRefTables.addAll(this.tableInfosA);
        allNonRefTables.addAll(this.tableInfosB);
        allNonRefTables.addAll(this.tableInfosAandB);
        return Collections.unmodifiableList(allNonRefTables);
    }

    @Override
    protected TableInfo getMimeTable() {
        return AbstractProfiler.MIME_TABLE;
    }

    @Override
    protected void addErrorLogTablePairs(DBConsumersManager manager) {
        Path errorLogA = PropsUtil.getPath((String)this.localAttrs.get("errorLogFileA"), null);
        if (errorLogA == null) {
            return;
        }
        manager.addErrorLogTablePair(errorLogA, ExtractComparer.EXTRACT_EXCEPTION_TABLE_A);
        Path errorLogB = PropsUtil.getPath((String)this.localAttrs.get("errorLogFileB"), null);
        if (errorLogB == null) {
            return;
        }
        manager.addErrorLogTablePair(errorLogB, ExtractComparer.EXTRACT_EXCEPTION_TABLE_B);
    }
}

