/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalProduct;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class WherePredicateStep<S>
extends FilterStep<S>
implements Scoping,
PathProcessor,
ByModulating,
TraversalParent {
    protected String startKey;
    protected List<String> selectKeys;
    protected P<Object> predicate;
    protected final Set<String> scopeKeys = new HashSet<String>();
    protected Set<String> keepLabels;
    protected TraversalRing<S, ?> traversalRing = new TraversalRing(new Traversal.Admin[0]);

    public WherePredicateStep(Traversal.Admin traversal, Optional<String> startKey, P<String> predicate) {
        super(traversal);
        this.startKey = startKey.orElse(null);
        if (null != this.startKey) {
            this.scopeKeys.add(this.startKey);
        }
        this.predicate = predicate;
        this.selectKeys = new ArrayList<String>();
        this.configurePredicates(this.predicate);
    }

    private void configurePredicates(P<Object> predicate) {
        if (predicate instanceof ConnectiveP) {
            ((ConnectiveP)predicate).getPredicates().forEach(this::configurePredicates);
        } else {
            String selectKey = this.getSelectKey(predicate);
            this.selectKeys.add(selectKey);
            this.scopeKeys.add(selectKey);
        }
    }

    private boolean setPredicateValues(P<Object> predicate, Traverser.Admin<S> traverser, Iterator<String> selectKeysIterator) {
        if (predicate instanceof ConnectiveP) {
            for (P<Object> p : ((ConnectiveP)predicate).getPredicates()) {
                if (this.setPredicateValues(p, traverser, selectKeysIterator)) continue;
                return false;
            }
            return true;
        }
        TraversalProduct product = TraversalUtil.produce(this.getSafeScopeValue(Pop.last, selectKeysIterator.next(), traverser), this.traversalRing.next());
        if (product.isProductive()) {
            predicate.setValue(product.get());
        }
        return product.isProductive();
    }

    public Optional<P<?>> getPredicate() {
        return Optional.ofNullable(this.predicate);
    }

    public Optional<String> getStartKey() {
        return Optional.ofNullable(this.startKey);
    }

    public String getSelectKey(P<Object> predicate) {
        return (String)(predicate.getValue() instanceof Collection ? ((Collection)predicate.getValue()).iterator().next() : predicate.getValue());
    }

    public void removeStartKey() {
        this.selectKeys.remove(this.startKey);
        this.startKey = null;
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        TraversalProduct product = null == this.startKey ? TraversalUtil.produce(traverser, this.traversalRing.next()) : TraversalUtil.produce(this.getSafeScopeValue(Pop.last, this.startKey, traverser), this.traversalRing.next());
        boolean predicateValuesProductive = this.setPredicateValues(this.predicate, traverser, this.selectKeys.iterator());
        this.traversalRing.reset();
        return product.isProductive() && predicateValuesProductive && this.predicate.test(product.get());
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.startKey, this.predicate, this.traversalRing);
    }

    @Override
    public Set<String> getScopeKeys() {
        return Collections.unmodifiableSet(this.scopeKeys);
    }

    @Override
    public WherePredicateStep<S> clone() {
        WherePredicateStep clone = (WherePredicateStep)super.clone();
        clone.predicate = this.predicate.clone();
        clone.traversalRing = this.traversalRing.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.traversalRing.hashCode() ^ (null == this.startKey ? "null".hashCode() : this.startKey.hashCode()) ^ this.predicate.hashCode();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.SIDE_EFFECTS);
    }

    public List<Traversal.Admin<S, ?>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    @Override
    protected Traverser.Admin<S> processNextStart() {
        return PathProcessor.processTraverserPathLabels(super.processNextStart(), this.keepLabels);
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> traversal) throws UnsupportedOperationException {
        this.traversalRing.addTraversal(this.integrateChild(traversal));
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        this.traversalRing.replaceTraversal(oldTraversal, this.integrateChild(newTraversal));
    }
}

