export type AuthenticatorOptions = {
    username?: string;
    password?: string;
    mechanism?: any;
};
export default abstract class Authenticator {
    protected readonly options: AuthenticatorOptions;
    constructor(options: AuthenticatorOptions);
    /**
     * Evaluates the challenge from the server and returns appropriate response.
     * @param {String} challenge Challenge string presented by the server.
     */
    abstract evaluateChallenge(challenge: string): any;
}
