/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.AbstractTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.TranslatorException;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public class JavascriptTranslateVisitor
extends AbstractTranslateVisitor {
    public JavascriptTranslateVisitor() {
        this("g");
    }

    public JavascriptTranslateVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    @Override
    public Void visitStructureVertex(GremlinParser.StructureVertexContext ctx) {
        this.sb.append("new Vertex(");
        this.visit(ctx.getChild(3));
        this.sb.append(", ");
        this.visit(ctx.getChild(5));
        this.sb.append(")");
        return null;
    }

    @Override
    public Void visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        this.sb.append("new ");
        if (ctx.getChildCount() == 1) {
            this.sb.append(ctx.getText()).append("()");
        } else {
            this.sb.append(ctx.getChild(0).getText().equals("new") ? ctx.getChild(1).getText() : ctx.getChild(0).getText()).append("({");
            List configs = ctx.children.stream().filter(c -> c instanceof GremlinParser.ConfigurationContext).collect(Collectors.toList());
            for (int ix = 0; ix < configs.size(); ++ix) {
                this.visit((ParseTree)configs.get(ix));
                if (ix >= configs.size() - 1) continue;
                this.sb.append(", ");
            }
            this.sb.append("})");
        }
        return null;
    }

    @Override
    public Void visitConfiguration(GremlinParser.ConfigurationContext ctx) {
        this.sb.append(SymbolHelper.toJavascript(ctx.getChild(0).getText()));
        this.sb.append(": ");
        this.visit(ctx.getChild(2));
        return null;
    }

    @Override
    public Void visitGenericLiteralMap(GremlinParser.GenericLiteralMapContext ctx) {
        this.sb.append("new Map([");
        for (int i = 0; i < ctx.mapEntry().size(); ++i) {
            GremlinParser.MapEntryContext mapEntryContext = ctx.mapEntry(i);
            this.visit((ParseTree)mapEntryContext);
            if (i >= ctx.mapEntry().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("])");
        return null;
    }

    @Override
    public Void visitMapEntry(GremlinParser.MapEntryContext ctx) {
        boolean isKeyWrappedInParens = ctx.getChild(0).getText().equals("(");
        this.sb.append("[");
        if (ctx.getChild(0) instanceof TerminalNode && !isKeyWrappedInParens) {
            this.wrapTextInQuotes(ctx.getChild(0).getText());
        } else {
            int indexOfActualKey = isKeyWrappedInParens ? 1 : 0;
            this.visit(ctx.getChild(indexOfActualKey));
        }
        this.sb.append(", ");
        int indexOfValue = isKeyWrappedInParens ? 4 : 2;
        this.visit(ctx.getChild(indexOfValue));
        this.sb.append("]");
        return null;
    }

    @Override
    public Void visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        String dtString = ctx.getChild(2).getText();
        OffsetDateTime dt = DatetimeHelper.parse(JavascriptTranslateVisitor.removeFirstAndLastCharacters(dtString));
        this.sb.append("new Date(");
        this.sb.append(dt.toInstant().toEpochMilli());
        this.sb.append(")");
        return null;
    }

    @Override
    public Void visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        this.sb.append("Number.NaN");
        return null;
    }

    @Override
    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        if (ctx.SignedInfLiteral().getText().equals("-Infinity")) {
            this.sb.append("Number.NEGATIVE_INFINITY");
        } else {
            this.sb.append("Number.POSITIVE_INFINITY");
        }
        return null;
    }

    @Override
    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        int lastCharIndex;
        String integerLiteral = ctx.getText().toLowerCase();
        char lastChar = integerLiteral.charAt(lastCharIndex = integerLiteral.length() - 1);
        if (Character.isAlphabetic(lastChar)) {
            this.sb.append(integerLiteral, 0, lastCharIndex);
        } else {
            this.sb.append(integerLiteral);
        }
        return null;
    }

    @Override
    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        int lastCharIndex;
        String floatLiteral = ctx.getText().toLowerCase();
        char lastChar = floatLiteral.charAt(lastCharIndex = floatLiteral.length() - 1);
        if (Character.isAlphabetic(lastChar)) {
            this.sb.append(floatLiteral, 0, lastCharIndex);
        } else {
            this.sb.append(floatLiteral);
        }
        return null;
    }

    @Override
    public Void visitGenericLiteralRange(GremlinParser.GenericLiteralRangeContext ctx) {
        throw new TranslatorException("Javascript does not support range literals");
    }

    @Override
    public Void visitGenericLiteralSet(GremlinParser.GenericLiteralSetContext ctx) {
        this.sb.append("new Set([");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("])");
        return null;
    }

    @Override
    public Void visitGenericLiteralCollection(GremlinParser.GenericLiteralCollectionContext ctx) {
        this.sb.append("[");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("]");
        return null;
    }

    @Override
    public Void visitTraversalCardinality(GremlinParser.TraversalCardinalityContext ctx) {
        if (ctx.getChildCount() == 1) {
            this.appendExplicitNaming(ctx.getText(), VertexProperty.Cardinality.class.getSimpleName());
        } else {
            String txt = ctx.getChild(0).getText();
            if (txt.startsWith("Cardinality.")) {
                txt = txt.replaceFirst("Cardinality.", "");
            }
            this.appendExplicitNaming(txt, "CardinalityValue");
            this.appendStepOpen();
            this.visit(ctx.getChild(2));
            this.appendStepClose();
        }
        return null;
    }

    @Override
    protected String processGremlinSymbol(String step) {
        return SymbolHelper.toJavascript(step);
    }

    private void wrapTextInQuotes(String text) {
        this.sb.append("\"");
        this.sb.append(text);
        this.sb.append("\"");
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_JS_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_JS_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toJavascript(String symbol) {
            return TO_JS_MAP.getOrDefault(symbol, symbol);
        }

        public static String toJava(String symbol) {
            return FROM_JS_MAP.getOrDefault(symbol, symbol);
        }

        static {
            TO_JS_MAP.put("from", "from_");
            TO_JS_MAP.put("in", "in_");
            TO_JS_MAP.put("with", "with_");
            TO_JS_MAP.forEach((k, v) -> FROM_JS_MAP.put((String)v, (String)k));
        }
    }
}

