/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal.step.map;

import java.io.IOException;
import java.util.Base64;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.clustering.connected.ConnectedComponentVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ConnectedComponent;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.Serializer;

public final class ConnectedComponentVertexProgramStep
extends VertexProgramStep
implements TraversalParent,
Configuring {
    private Parameters parameters = new Parameters();
    private PureTraversal<Vertex, Edge> edgeTraversal;
    private String clusterProperty = "gremlin.connectedComponentVertexProgram.component";

    public ConnectedComponentVertexProgramStep(Traversal.Admin traversal) {
        super(traversal);
        this.configure(ConnectedComponent.edges, __.bothE());
    }

    @Override
    public void configure(Object ... keyValues) {
        if (keyValues[0].equals(ConnectedComponent.edges)) {
            if (!(keyValues[1] instanceof Traversal)) {
                throw new IllegalArgumentException("ConnectedComponent.edges requires a Traversal as its argument");
            }
            this.edgeTraversal = new PureTraversal(((Traversal)keyValues[1]).asAdmin());
            this.integrateChild(this.edgeTraversal.get());
        } else if (keyValues[0].equals(ConnectedComponent.propertyName)) {
            if (!(keyValues[1] instanceof String)) {
                throw new IllegalArgumentException("ConnectedComponent.propertyName requires a String as its argument");
            }
            this.clusterProperty = (String)keyValues[1];
        } else {
            this.parameters.set(this, keyValues);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.clusterProperty.hashCode();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.clusterProperty, new GraphFilter(this.computer));
    }

    @Override
    public ConnectedComponentVertexProgram generateProgram(Graph graph, Memory memory) {
        TraverserSet haltedTraversers;
        Traversal.Admin<Vertex, Edge> detachedTraversal = this.edgeTraversal.getPure();
        detachedTraversal.setStrategies(TraversalStrategies.GlobalCache.getStrategies(graph.getClass()));
        ConnectedComponentVertexProgram.Builder builder = ConnectedComponentVertexProgram.build().edges(detachedTraversal).property(this.clusterProperty);
        if (memory.exists("gremlin.traversalVertexProgram.haltedTraversers") && !(haltedTraversers = (TraverserSet)memory.get("gremlin.traversalVertexProgram.haltedTraversers")).isEmpty()) {
            Object haltedTraversersValue;
            try {
                haltedTraversersValue = Base64.getEncoder().encodeToString(Serializer.serializeObject(haltedTraversers));
            }
            catch (IOException ignored) {
                haltedTraversersValue = haltedTraversers;
            }
            builder.configure("gremlin.traversalVertexProgram.haltedTraversers", haltedTraversersValue);
        }
        return (ConnectedComponentVertexProgram)builder.create(graph);
    }

    @Override
    public ConnectedComponentVertexProgramStep clone() {
        return (ConnectedComponentVertexProgramStep)super.clone();
    }
}

