/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionBoolean;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.FunctionSQL;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.OpTypes;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Routine;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Collation;
import org.hsqldb.types.NullType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class Expression
implements Cloneable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int THIRD = 2;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int TERNARY = 3;
    static final Expression[] emptyArray = new Expression[0];
    public static final Expression EXPR_TRUE = new ExpressionBoolean(true);
    public static final Expression EXPR_FALSE = new ExpressionBoolean(false);
    protected int opType;
    protected int exprSubType;
    HsqlNameManager.SimpleName alias;
    private boolean hasAggregate;
    boolean isDistinctAggregate;
    protected Object valueData;
    protected Expression[] nodes;
    Type[] nodeDataTypes;
    TableDerived table;
    boolean isCorrelated;
    boolean noOptimisation;
    int columnIndex = -1;
    protected Type dataType;
    protected int groupingType;
    int resultTableColumnIndex = -1;
    int parameterIndex = -1;
    boolean isColumnCondition;
    boolean isColumnEqual;
    boolean isSingleColumnCondition;
    boolean isSingleColumnEqual;
    boolean isSingleColumnNull;
    boolean isSingleColumnNotNull;
    byte nullability = (byte)2;
    Collation collation;
    RangeGroup[] rangeGroups;
    RangeGroup rangeGroup;

    Expression(int n) {
        this.opType = n;
        this.nodes = emptyArray;
    }

    Expression(int n, TableDerived tableDerived) {
        switch (n) {
            case 19: {
                this.opType = 19;
                break;
            }
            case 102: {
                this.opType = 102;
                break;
            }
            case 23: {
                this.opType = 23;
                break;
            }
            case 21: 
            case 22: {
                this.opType = 22;
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        this.nodes = emptyArray;
        this.table = tableDerived;
    }

    Expression(int n, Expression[] expressionArray) {
        this(n);
        this.nodes = expressionArray;
    }

    static String getContextSQL(Expression expression) {
        if (expression == null) {
            return null;
        }
        String string = expression.getSQL();
        switch (expression.opType) {
            case 1: 
            case 2: 
            case 25: 
            case 27: 
            case 28: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                return string;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('(').append(string).append(')');
        return stringBuilder.toString();
    }

    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 25: {
                stringBuilder.append('(');
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(this.nodes[i].getSQL());
                }
                stringBuilder.append(')');
                break;
            }
            case 26: {
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(this.nodes[i].getSQL());
                }
                break;
            }
            case 19: {
                stringBuilder.append("ARRAY").append('[');
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(this.nodes[i].getSQL());
                }
                stringBuilder.append(']');
                break;
            }
            case 22: 
            case 23: 
            case 102: {
                stringBuilder.append('(').append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        return stringBuilder.toString();
    }

    protected String describe(Session session, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (n2 = 0; n2 < n; ++n2) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuilder.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData)).append(", TYPE = ").append(this.dataType.getNameString());
                break;
            }
            case 19: {
                stringBuilder.append("ARRAY ");
                break;
            }
            case 102: {
                stringBuilder.append("ARRAY SUBQUERY");
                break;
            }
            case 22: 
            case 23: {
                stringBuilder.append("QUERY ").append(this.table.queryExpression.describe(session, n));
                break;
            }
            case 25: {
                stringBuilder.append("ROW = ");
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    stringBuilder.append(this.nodes[n2].describe(session, n + 1)).append(' ');
                }
                break;
            }
            case 26: {
                stringBuilder.append("VALUELIST ");
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    stringBuilder.append(this.nodes[n2].describe(session, n + 1)).append(' ');
                }
                break;
            }
        }
        return stringBuilder.toString();
    }

    public void setDataType(Session session, Type type) {
        if (this.opType == 1) {
            this.valueData = type.convertToType(session, this.valueData, this.dataType);
        }
        this.dataType = type;
    }

    boolean equals(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (this.opType != expression.opType || this.exprSubType != expression.exprSubType || !Expression.equals(this.dataType, expression.dataType)) {
            return false;
        }
        switch (this.opType) {
            case 1: {
                return Expression.equals(this.valueData, expression.valueData);
            }
            case 22: 
            case 23: 
            case 102: {
                return this.table.queryExpression.isEquivalent(expression.table.queryExpression);
            }
        }
        return Expression.equals(this.nodes, expression.nodes);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Expression) {
            return this.equals((Expression)object);
        }
        return false;
    }

    public int hashCode() {
        int n = this.opType + this.exprSubType;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            n += this.nodes[i].hashCode();
        }
        return n;
    }

    static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        return object != null && object.equals(object2);
    }

    static boolean equals(Expression[] expressionArray, Expression[] expressionArray2) {
        if (expressionArray == expressionArray2) {
            return true;
        }
        if (expressionArray.length != expressionArray2.length) {
            return false;
        }
        int n = expressionArray.length;
        for (int i = 0; i < n; ++i) {
            Expression expression = expressionArray[i];
            Expression expression2 = expressionArray2[i];
            boolean bl = Expression.equals(expression, expression2);
            if (bl) continue;
            return false;
        }
        return true;
    }

    boolean isComposedOf(Expression[] expressionArray, int n, int n2, OrderedIntHashSet orderedIntHashSet) {
        int n3;
        switch (this.opType) {
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        if (orderedIntHashSet.contains(this.opType)) {
            return true;
        }
        for (n3 = n; n3 < n2; n3 += 1) {
            if (!this.equals(expressionArray[n3])) continue;
            return true;
        }
        switch (this.opType) {
            case 2: 
            case 19: 
            case 23: 
            case 53: 
            case 55: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 102: {
                return false;
            }
            case 22: {
                if (this.table == null) break;
                if (!(this.table.getQueryExpression() instanceof QuerySpecification)) {
                    return false;
                }
                QuerySpecification querySpecification = (QuerySpecification)this.table.getQueryExpression();
                OrderedHashSet<Expression> orderedHashSet = new OrderedHashSet<Expression>();
                for (int i = n; i < n2; ++i) {
                    if (expressionArray[i].opType != 2) continue;
                    orderedHashSet.add(expressionArray[i]);
                }
                return querySpecification.collectOuterColumnExpressions(null, orderedHashSet) == null;
            }
        }
        if (this.isSelfAggregate()) {
            return false;
        }
        if (this.nodes.length == 0) {
            return true;
        }
        n3 = 1;
        for (int i = 0; i < this.nodes.length; ++i) {
            n3 &= this.nodes[i] == null || this.nodes[i].isComposedOf(expressionArray, n, n2, orderedIntHashSet);
        }
        return n3 != 0;
    }

    boolean isComposedOf(OrderedHashSet<Expression> orderedHashSet, RangeGroup[] rangeGroupArray, OrderedIntHashSet orderedIntHashSet) {
        int n;
        switch (this.opType) {
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        if (orderedIntHashSet.contains(this.opType)) {
            return true;
        }
        for (n = 0; n < orderedHashSet.size(); n += 1) {
            if (!this.equals(orderedHashSet.get(n))) continue;
            return true;
        }
        if (this.opType == 2) {
            for (n = 0; n < rangeGroupArray.length; n += 1) {
                RangeVariable[] rangeVariableArray = rangeGroupArray[n].getRangeVariables();
                for (int i = 0; i < rangeVariableArray.length; ++i) {
                    if (rangeVariableArray[i] != this.getRangeVariable()) continue;
                    return true;
                }
            }
        }
        switch (this.opType) {
            case 27: 
            case 28: {
                if (this.nodes.length != 0) break;
                return true;
            }
        }
        if (this.isSelfAggregate()) {
            return false;
        }
        if (this.nodes.length == 0) {
            return false;
        }
        n = 1;
        for (int i = 0; i < this.nodes.length; ++i) {
            n &= this.nodes[i] == null || this.nodes[i].isComposedOf(orderedHashSet, rangeGroupArray, orderedIntHashSet);
        }
        return n != 0;
    }

    Expression replaceColumnReferences(Session session, RangeVariable rangeVariable, Expression[] expressionArray) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        return this;
    }

    void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
    }

    void resetColumnReferences() {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resetColumnReferences();
        }
    }

    Expression replaceExpressions(OrderedHashSet<Expression> orderedHashSet, int n) {
        if (this.opType == 1) {
            return this;
        }
        if (this.opType == 5) {
            return this;
        }
        Expression expression = orderedHashSet.get(this);
        if (expression != null) {
            ExpressionColumn expressionColumn = new ExpressionColumn(this, expression.resultTableColumnIndex, n);
            return expressionColumn;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceExpressions(orderedHashSet, n);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.replaceExpressions(orderedHashSet, n);
        }
        return this;
    }

    boolean hasAggregate() {
        return this.hasAggregate;
    }

    boolean isDistinctAggregate() {
        return this.isDistinctAggregate;
    }

    public void setAggregate() {
        this.hasAggregate = true;
    }

    public boolean isSelfAggregate() {
        return false;
    }

    void setAlias(HsqlNameManager.SimpleName simpleName) {
        this.alias = simpleName;
    }

    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        return "";
    }

    HsqlNameManager.SimpleName getSimpleName() {
        return this.alias;
    }

    public int getType() {
        return this.opType;
    }

    public Expression getLeftNode() {
        return this.nodes.length > 0 ? this.nodes[0] : null;
    }

    public Expression getRightNode() {
        return this.nodes.length > 1 ? this.nodes[1] : null;
    }

    void setLeftNode(Expression expression) {
        this.nodes[0] = expression;
    }

    public void setRightNode(Expression expression) {
        this.nodes[1] = expression;
    }

    int getSubType() {
        return this.exprSubType;
    }

    void setSubType(int n) {
        this.exprSubType = n;
    }

    RangeVariable getRangeVariable() {
        return null;
    }

    Expression replaceAliasInOrderBy(Session session, List<Expression> list, int n) {
        if (this.isSelfAggregate()) {
            return this;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceAliasInOrderBy(session, list, n);
        }
        return this;
    }

    OrderedHashSet<RangeVariable> collectRangeVariables(OrderedHashSet<RangeVariable> orderedHashSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            orderedHashSet = this.nodes[i].collectRangeVariables(orderedHashSet);
        }
        if (this.table != null && this.table.queryExpression != null) {
            orderedHashSet = this.table.queryExpression.collectRangeVariables(orderedHashSet);
        }
        return orderedHashSet;
    }

    OrderedHashSet<RangeVariable> collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet<RangeVariable> orderedHashSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            orderedHashSet = this.nodes[i].collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        if (this.table != null && this.table.queryExpression != null) {
            orderedHashSet = this.table.queryExpression.collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        return orderedHashSet;
    }

    void collectObjectNames(Set<HsqlNameManager.HsqlName> set) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].collectObjectNames(set);
        }
        if (this.table != null && this.table.queryExpression != null) {
            this.table.queryExpression.collectObjectNames(set);
        }
    }

    boolean hasReference(RangeVariable rangeVariable) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(rangeVariable)) continue;
            return true;
        }
        if (this.table != null && this.table.queryExpression != null) {
            return this.table.queryExpression.hasReference(rangeVariable);
        }
        return false;
    }

    boolean hasReference(RangeVariable[] rangeVariableArray, int n) {
        OrderedHashSet<RangeVariable> orderedHashSet = this.collectRangeVariables(rangeVariableArray, null);
        if (orderedHashSet == null) {
            return false;
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            if (orderedHashSet.get(i) == rangeVariableArray[n]) continue;
            return true;
        }
        return false;
    }

    public List<Expression> resolveColumnReferences(Session session, RangeGroup rangeGroup, RangeGroup[] rangeGroupArray, List<Expression> list) {
        return this.resolveColumnReferences(session, rangeGroup, rangeGroup.getRangeVariables().length, rangeGroupArray, list, true);
    }

    public List<Expression> resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, List<Expression> list, boolean bl) {
        if (this.opType == 1) {
            return list;
        }
        switch (this.opType) {
            case 26: 
            case 30: {
                if (this.table != null) {
                    if (rangeGroup.getRangeVariables().length > n) {
                        RangeVariable[] rangeVariableArray = (RangeVariable[])ArrayUtil.resizeArray(rangeGroup.getRangeVariables(), n);
                        rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariableArray, rangeGroup);
                    }
                    rangeGroupArray = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroupArray, rangeGroup, rangeGroupArray.length, 1);
                    rangeGroup = new RangeGroup.RangeGroupSimple(this.table);
                    n = 0;
                }
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    list = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, list, bl);
                }
                return list;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            list = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, list, bl);
        }
        switch (this.opType) {
            case 19: {
                break;
            }
            case 22: 
            case 23: 
            case 102: {
                Expression expression;
                RangeVariable[] rangeVariableArray = rangeGroup.getRangeVariables();
                if (rangeVariableArray.length > n) {
                    rangeVariableArray = (RangeVariable[])ArrayUtil.resizeArray(rangeVariableArray, n);
                    rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariableArray, rangeGroup);
                }
                rangeGroupArray = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroupArray, rangeGroup, rangeGroupArray.length, 1);
                QueryExpression queryExpression = this.table.queryExpression;
                if (queryExpression != null) {
                    queryExpression.resolveReferences(session, rangeGroupArray);
                    if (!queryExpression.areColumnsResolved()) {
                        if (list == null) {
                            list = new ArrayListIdentity<Expression>();
                        }
                        list.addAll(queryExpression.getUnresolvedExpressions());
                    }
                }
                if ((expression = this.table.dataExpression) == null) break;
                list = expression.resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, list, bl);
                break;
            }
        }
        return list;
    }

    public void setCorrelatedReferences(RangeGroup rangeGroup) {
        if (this.rangeGroups == null) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                this.nodes[i].setCorrelatedReferences(rangeGroup);
            }
        } else if (ArrayUtil.find(this.rangeGroups, rangeGroup) > -1) {
            for (int i = this.rangeGroups.length - 1; i >= 0 && this.rangeGroups[i] != rangeGroup; --i) {
                this.rangeGroups[i].setCorrelated();
            }
            this.rangeGroup.setCorrelated();
        }
    }

    public OrderedHashSet<Expression> getUnkeyedColumns(OrderedHashSet<Expression> orderedHashSet) {
        if (this.opType == 1) {
            return orderedHashSet;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            orderedHashSet = this.nodes[i].getUnkeyedColumns(orderedHashSet);
        }
        switch (this.opType) {
            case 19: 
            case 22: 
            case 23: 
            case 102: {
                if (this.table == null) break;
                if (orderedHashSet == null) {
                    orderedHashSet = new OrderedHashSet();
                }
                orderedHashSet.add(this);
                break;
            }
        }
        return orderedHashSet;
    }

    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: 
            case 26: {
                break;
            }
            case 25: {
                this.nodeDataTypes = new Type[this.nodes.length];
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n] == null) continue;
                    this.nodeDataTypes[n] = this.nodes[n].dataType;
                }
                this.dataType = new RowType(this.nodeDataTypes);
                break;
            }
            case 19: {
                int n2;
                Type type = null;
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    type = Type.getAggregateType(type, this.nodes[n2].dataType);
                }
                if (type != null) {
                    for (n2 = 0; n2 < this.nodes.length; ++n2) {
                        this.nodes[n2].valueData = this.nodes[n2].dataType == null ? type.convertToDefaultType(session, this.nodes[n2].valueData) : type.convertToType(session, this.nodes[n2].valueData, this.nodes[n2].dataType);
                    }
                }
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    this.nodes[n2].dataType = type;
                }
                this.dataType = new ArrayType(type, 0x100000);
                return;
            }
            case 102: {
                QueryExpression queryExpression = this.table.queryExpression;
                queryExpression.resolveTypes(session);
                this.table.prepareTable(session);
                this.nodeDataTypes = queryExpression.getColumnTypes();
                this.dataType = this.nodeDataTypes[0];
                if (this.nodeDataTypes.length > 1) {
                    throw Error.error(5564);
                }
                this.dataType = new ArrayType(this.dataType, Integer.MAX_VALUE);
                break;
            }
            case 22: 
            case 23: {
                Expression expression2;
                QueryExpression queryExpression = this.table.queryExpression;
                if (queryExpression != null) {
                    queryExpression.resolveTypes(session);
                }
                if ((expression2 = this.table.dataExpression) != null) {
                    expression2.resolveTypes(session, null);
                }
                this.table.prepareTable(session);
                this.nodeDataTypes = this.table.getColumnTypes();
                this.dataType = this.nodeDataTypes[0];
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
    }

    void setAsConstantValue(Session session, Expression expression) {
        this.valueData = this.getValue(session);
        this.opType = 1;
        this.nodes = emptyArray;
    }

    void setAsConstantValue(Object object, Expression expression) {
        this.valueData = object;
        this.opType = 1;
        this.nodes = emptyArray;
    }

    void prepareTable(Session session, Expression expression, int n) {
        Cloneable cloneable;
        int n2;
        if (this.nodeDataTypes != null) {
            return;
        }
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            cloneable = this.nodes[n2];
            if (((Expression)cloneable).opType == 25) {
                if (n == ((Expression)cloneable).nodes.length) continue;
                throw Error.error(5564);
            }
            if (n == 1) {
                this.nodes[n2] = new Expression(25);
                this.nodes[n2].nodes = new Expression[]{cloneable};
                continue;
            }
            throw Error.error(5564);
        }
        this.nodeDataTypes = new Type[n];
        for (n2 = 0; n2 < n; ++n2) {
            int n3;
            cloneable = expression == null ? null : expression.nodes[n2].dataType;
            boolean bl = expression != null && expression.nodes[n2].isUnresolvedParam();
            for (n3 = 0; n3 < this.nodes.length; ++n3) {
                cloneable = Type.getAggregateType(this.nodes[n3].nodes[n2].dataType, (Type)cloneable);
                bl |= this.nodes[n3].nodes[n2].isUnresolvedParam();
            }
            if (cloneable == null) {
                cloneable = Type.SQL_VARCHAR_DEFAULT;
            }
            n3 = ((Type)cloneable).typeCode;
            if (bl && ((Type)cloneable).isCharacterType() && (n3 == 1 || ((Type)cloneable).precision < Type.SQL_VARCHAR_DEFAULT.precision)) {
                if (n3 == 1) {
                    n3 = 12;
                }
                long l = Math.max(Type.SQL_VARCHAR_DEFAULT.precision, ((Type)cloneable).precision);
                cloneable = CharacterType.getCharacterType(n3, l, ((Type)cloneable).getCollation());
            }
            this.nodeDataTypes[n2] = cloneable;
            if (expression != null && expression.nodes[n2].isUnresolvedParam()) {
                expression.nodes[n2].dataType = cloneable;
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                Expression expression2 = this.nodes[i];
                if (expression2.nodes[n2].isUnresolvedParam()) {
                    expression2.nodeDataTypes[n2] = expression2.nodes[n2].dataType = this.nodeDataTypes[n2];
                    continue;
                }
                if (expression2.nodes[n2].opType != 1 || expression2.nodes[n2].valueData != null) continue;
                expression2.nodeDataTypes[n2] = expression2.nodes[n2].dataType = this.nodeDataTypes[n2];
            }
        }
    }

    void insertValuesIntoSubqueryTable(Session session, PersistentStore persistentStore) {
        for (int i = 0; i < this.nodes.length; ++i) {
            Object[] objectArray = this.nodes[i].getRowValue(session);
            Object[] objectArray2 = persistentStore.getTable().getEmptyRowData();
            for (int j = 0; j < this.nodeDataTypes.length; ++j) {
                objectArray2[j] = this.nodeDataTypes[j].convertToType(session, objectArray[j], this.nodes[i].nodes[j].dataType);
            }
            Row row = (Row)persistentStore.getNewCachedObject(session, objectArray2, false);
            try {
                persistentStore.indexRow(session, row);
                continue;
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    String getColumnName() {
        return this.getAlias();
    }

    public ColumnSchema getColumn() {
        return null;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Type getDataType() {
        return this.dataType;
    }

    byte getNullability() {
        return this.nullability;
    }

    Type getNodeDataType(int n) {
        if (this.nodeDataTypes == null) {
            if (n > 0) {
                throw Error.runtimeError(201, "Expression");
            }
            return this.dataType;
        }
        return this.nodeDataTypes[n];
    }

    Type[] getNodeDataTypes() {
        if (this.nodeDataTypes == null) {
            return new Type[]{this.dataType};
        }
        return this.nodeDataTypes;
    }

    int getDegree() {
        switch (this.opType) {
            case 25: {
                return this.nodes.length;
            }
            case 22: 
            case 23: 
            case 30: {
                if (this.table == null) {
                    return this.nodeDataTypes.length;
                }
                return this.table.queryExpression.getColumnCount();
            }
        }
        return 1;
    }

    public Table getTable() {
        return this.table;
    }

    public void materialise(Session session) {
        if (this.table == null) {
            return;
        }
        if (this.table.isCorrelated()) {
            this.table.materialiseCorrelated(session);
        } else {
            this.table.materialise(session);
        }
    }

    public Object getValue(Session session, Type type) {
        Object object = this.getValue(session);
        if (object == null || this.dataType == type) {
            return object;
        }
        return type.convertToType(session, object, this.dataType);
    }

    public Object getConstantValueNoCheck(Session session) {
        try {
            return this.getValue(session);
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 25: {
                Object[] objectArray = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    objectArray[i] = this.nodes[i].getValue(session);
                }
                return objectArray;
            }
            case 22: 
            case 23: {
                return this.table.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 25: {
                if (this.nodes.length == 1) {
                    return this.nodes[0].getValue(session);
                }
                Object[] objectArray = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    objectArray[i] = this.nodes[i].getValue(session);
                }
                return objectArray;
            }
            case 19: {
                Object[] objectArray = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    objectArray[i] = this.nodes[i].getValue(session);
                }
                return objectArray;
            }
            case 102: {
                this.table.materialiseCorrelated(session);
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                int n = rowSetNavigatorData.getSize();
                Object[] objectArray = new Object[n];
                rowSetNavigatorData.beforeFirst();
                int n2 = 0;
                while (rowSetNavigatorData.next()) {
                    Object[] objectArray2 = rowSetNavigatorData.getCurrent();
                    objectArray[n2] = objectArray2[0];
                    ++n2;
                }
                return objectArray;
            }
            case 22: 
            case 23: {
                this.table.materialiseCorrelated(session);
                Object[] objectArray = this.table.getValues(session);
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                return objectArray;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    public Result getResult(Session session) {
        switch (this.opType) {
            case 19: {
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                Object[] objectArray = new Object[rowSetNavigatorData.getSize()];
                rowSetNavigatorData.beforeFirst();
                int n = 0;
                while (rowSetNavigatorData.next()) {
                    Object[] objectArray2 = rowSetNavigatorData.getCurrent();
                    objectArray[n] = objectArray2[0];
                    ++n;
                }
                return Result.newPSMResult(objectArray);
            }
            case 23: {
                this.table.materialiseCorrelated(session);
                RowSetNavigatorData rowSetNavigatorData = this.table.getNavigator(session);
                Result result = Result.newResult(rowSetNavigatorData);
                result.metaData = this.table.queryExpression == null ? ResultMetaData.newResultMetaData(this.table.getColumnTypes(), this.table.getColumnLabels()) : this.table.queryExpression.getMetaData();
                return result;
            }
        }
        Object object = this.getValue(session);
        return Result.newPSMResult(object);
    }

    public boolean testCondition(Session session) {
        return Boolean.TRUE.equals(this.getValue(session));
    }

    static int countNulls(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            ++n;
        }
        return n;
    }

    public boolean isTrue() {
        return this.opType == 1 && this.valueData instanceof Boolean && (Boolean)this.valueData != false;
    }

    public boolean isFalse() {
        return this.opType == 1 && this.valueData instanceof Boolean && (Boolean)this.valueData == false;
    }

    public boolean isIndexable(RangeVariable rangeVariable) {
        return false;
    }

    static void convertToType(Session session, Object[] objectArray, Type[] typeArray, Type[] typeArray2) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (typeArray[i].canConvertFrom(typeArray2[i])) continue;
            objectArray[i] = typeArray2[i].convertToType(session, objectArray[i], typeArray[i]);
        }
    }

    static QuerySpecification getCheckSelect(Session session, Table table, Expression expression) {
        ParserDQL.CompileContext compileContext = new ParserDQL.CompileContext(session);
        compileContext.setNextRangeVarIndex(0);
        QuerySpecification querySpecification = new QuerySpecification(compileContext);
        RangeVariable rangeVariable = new RangeVariable(table, null, null, null, compileContext);
        RangeVariable[] rangeVariableArray = new RangeVariable[]{rangeVariable};
        RangeGroup.RangeGroupSimple rangeGroupSimple = new RangeGroup.RangeGroupSimple(rangeVariableArray, false);
        expression.resolveCheckOrGenExpression(session, rangeGroupSimple, true);
        if (Type.SQL_BOOLEAN != expression.getDataType()) {
            throw Error.error(5568);
        }
        ExpressionLogical expressionLogical = new ExpressionLogical(48, expression);
        querySpecification.addSelectColumnExpression(EXPR_TRUE);
        querySpecification.addRangeVariable(session, rangeVariable);
        querySpecification.addQueryCondition(expressionLogical);
        querySpecification.resolve(session);
        return querySpecification;
    }

    public void resolveCheckOrGenExpression(Session session, RangeGroup rangeGroup, boolean bl) {
        Object object;
        Object object2;
        int n;
        boolean bl2 = false;
        OrderedHashSet<Expression> orderedHashSet = new OrderedHashSet<Expression>();
        List<Expression> list = this.resolveColumnReferences(session, rangeGroup, RangeGroup.emptyArray, null);
        ExpressionColumn.checkColumnsResolved(list);
        this.resolveTypes(session, null);
        this.collectAllExpressions(orderedHashSet, OpTypes.subqueryAggregateExpressionSet, OpTypes.emptyExpressionSet);
        if (!orderedHashSet.isEmpty()) {
            throw Error.error(5512);
        }
        this.collectAllExpressions(orderedHashSet, OpTypes.functionExpressionSet, OpTypes.emptyExpressionSet);
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Expression expression = orderedHashSet.get(i);
            if (expression.opType == 27 && !((FunctionSQLInvoked)expression).isDeterministic()) {
                throw Error.error(5512);
            }
            if (expression.opType != 28 || ((FunctionSQL)expression).isDeterministic()) continue;
            if (bl) {
                bl2 = true;
                continue;
            }
            throw Error.error(5512);
        }
        if (bl && bl2) {
            HsqlArrayList<Expression> hsqlArrayList = new HsqlArrayList<Expression>();
            RangeVariableResolver.decomposeAndConditions(session, this, hsqlArrayList);
            block9: for (int i = 0; i < hsqlArrayList.size(); ++i) {
                bl2 = true;
                Expression expression = hsqlArrayList.get(i);
                if (!(expression instanceof ExpressionLogical) || (n = ((ExpressionLogical)expression).convertToSmaller()) == 0) break;
                object2 = expression.getRightNode();
                expression = expression.getLeftNode();
                if (!expression.dataType.isDateTimeType()) {
                    bl2 = true;
                    break;
                }
                if (expression.hasNonDeterministicFunction()) {
                    bl2 = true;
                    break;
                }
                if (object2 instanceof ExpressionArithmetic) {
                    if (this.opType == 32) {
                        if (((Expression)object2).getRightNode().hasNonDeterministicFunction()) {
                            ((Expression)object2).swapLeftAndRightNodes();
                        }
                    } else if (this.opType != 33) break;
                    if (((Expression)object2).getRightNode().hasNonDeterministicFunction()) break;
                    object2 = ((Expression)object2).getLeftNode();
                }
                if (((Expression)object2).opType != 28) break;
                object = (FunctionSQL)object2;
                switch (((FunctionSQL)object).funcType) {
                    case 43: 
                    case 50: 
                    case 52: {
                        bl2 = false;
                        continue block9;
                    }
                }
            }
            if (bl2) {
                throw Error.error(5512);
            }
        }
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = new OrderedHashSet<HsqlNameManager.HsqlName>();
        this.collectObjectNames(orderedHashSet2);
        RangeVariable[] rangeVariableArray = rangeGroup.getRangeVariables();
        block10: for (int i = 0; i < orderedHashSet2.size(); ++i) {
            object2 = orderedHashSet2.get(i);
            switch (((HsqlNameManager.HsqlName)object2).type) {
                case 9: {
                    if (bl || !((ColumnSchema)(object = rangeVariableArray[0].rangeTable.getColumn(n = rangeVariableArray[0].rangeTable.findColumn(((HsqlNameManager.HsqlName)object2).name)))).isGenerated()) continue block10;
                    throw Error.error(5512);
                }
                case 7: {
                    throw Error.error(5512);
                }
                case 24: {
                    Routine routine = (Routine)session.database.schemaManager.findSchemaObject((HsqlNameManager.HsqlName)object2);
                    if (!routine.isDeterministic()) {
                        throw Error.error(5512);
                    }
                    int n2 = routine.getDataImpact();
                    if (n2 != 3 && n2 != 4) continue block10;
                    throw Error.error(5512);
                }
            }
        }
    }

    boolean isUnresolvedParam() {
        return false;
    }

    boolean isDynamicParam() {
        return false;
    }

    boolean hasNonDeterministicFunction() {
        OrderedHashSet<Expression> orderedHashSet = this.collectAllExpressions(null, OpTypes.functionExpressionSet, OpTypes.emptyExpressionSet);
        if (orderedHashSet == null) {
            return false;
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Expression expression = orderedHashSet.get(i);
            if (!(expression.opType == 27 ? !((FunctionSQLInvoked)expression).isDeterministic() : expression.opType == 28 && !((FunctionSQL)expression).isDeterministic())) continue;
            return true;
        }
        return false;
    }

    void swapLeftAndRightNodes() {
        Expression expression = this.nodes[0];
        this.nodes[0] = this.nodes[1];
        this.nodes[1] = expression;
    }

    void setAttributesAsColumn(ColumnSchema columnSchema) {
        throw Error.runtimeError(201, "Expression");
    }

    String getValueClassName() {
        Type type = this.dataType == null ? NullType.getNullType() : this.dataType;
        return type.getJDBCClassName();
    }

    public final OrderedHashSet<Expression> collectAllExpressions(OrderedHashSet<Expression> orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        int n;
        if (orderedIntHashSet2.contains(this.opType)) {
            return orderedHashSet;
        }
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            orderedHashSet = this.nodes[n].collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        n = 0;
        if (orderedIntHashSet.contains(this.opType)) {
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet();
            }
            orderedHashSet.add(this);
            n = 1;
        }
        if (n == 0 && this.table != null && this.table.queryExpression != null) {
            orderedHashSet = this.table.queryExpression.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    public void setNoOptimisation() {
        this.noOptimisation = true;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].setNoOptimisation();
        }
    }

    public final OrderedHashSet<TableDerived> getSubqueries() {
        return this.collectAllSubqueries(null);
    }

    final OrderedHashSet<TableDerived> collectAllSubqueries(OrderedHashSet<TableDerived> orderedHashSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            orderedHashSet = this.nodes[i].collectAllSubqueries(orderedHashSet);
        }
        if (this.table != null) {
            if (this.table.queryExpression != null) {
                OrderedHashSet<TableDerived> orderedHashSet2 = this.table.queryExpression.getSubqueries();
                orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
            }
            if (orderedHashSet == null) {
                orderedHashSet = new OrderedHashSet();
            }
            orderedHashSet.add(this.table);
        }
        return orderedHashSet;
    }

    public boolean isCorrelated() {
        if (this.table == null) {
            return false;
        }
        return this.table.isCorrelated();
    }

    public void checkValidCheckConstraint() {
        OrderedHashSet<Expression> orderedHashSet = this.collectAllExpressions(null, OpTypes.subqueryAggregateExpressionSet, OpTypes.emptyExpressionSet);
        if (orderedHashSet != null && !orderedHashSet.isEmpty()) {
            throw Error.error(1500, "subquery in check constraint");
        }
    }

    public void resolveGrantFilter(Session session, Table table) {
        TableDerived tableDerived;
        RangeGroup.RangeGroupSimple rangeGroupSimple = new RangeGroup.RangeGroupSimple(table.getDefaultRanges(), false);
        List<Expression> list = this.resolveColumnReferences(session, rangeGroupSimple, RangeGroup.emptyArray, null);
        if (list != null && list.size() > 0) {
            Expression expression = list.get(0);
            String string = expression.getColumnName();
            throw Error.error(5501, string);
        }
        OrderedHashSet<TableDerived> orderedHashSet = this.collectAllSubqueries(null);
        if (orderedHashSet != null && orderedHashSet.size() > 0 && (tableDerived = (TableDerived)orderedHashSet.get(0)).isCorrelated()) {
            throw Error.error(5501);
        }
    }

    static List<Expression> resolveColumnSet(Session session, RangeVariable[] rangeVariableArray, RangeGroup[] rangeGroupArray, List<Expression> list) {
        return Expression.resolveColumnSet(session, rangeVariableArray, rangeVariableArray.length, rangeGroupArray, list, null);
    }

    static List<Expression> resolveColumnSet(Session session, RangeVariable[] rangeVariableArray, int n, RangeGroup[] rangeGroupArray, List<Expression> list, List<Expression> list2) {
        if (list == null) {
            return list2;
        }
        RangeGroup.RangeGroupSimple rangeGroupSimple = new RangeGroup.RangeGroupSimple(rangeVariableArray, false);
        for (int i = 0; i < list.size(); ++i) {
            Expression expression = list.get(i);
            list2 = expression.resolveColumnReferences(session, rangeGroupSimple, n, rangeGroupArray, list2, false);
        }
        return list2;
    }

    boolean isConditionRangeVariable(RangeVariable rangeVariable) {
        return false;
    }

    void getJoinRangeVariables(RangeVariable[] rangeVariableArray, List<RangeVariable> list) {
    }

    double costFactor(Session session, RangeVariable rangeVariable, int n) {
        return 16.0;
    }

    Expression getIndexableExpression(RangeVariable rangeVariable) {
        return null;
    }

    public Expression duplicate() {
        Expression expression;
        try {
            expression = (Expression)super.clone();
            expression.nodes = (Expression[])this.nodes.clone();
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                expression.nodes[i] = this.nodes[i].duplicate();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "Expression");
        }
        return expression;
    }

    void replaceNode(Expression expression, Expression expression2) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] != expression) continue;
            expression2.alias = this.nodes[i].alias;
            this.nodes[i] = expression2;
            return;
        }
        throw Error.runtimeError(201, "Expression");
    }

    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction) {
        throw Error.runtimeError(201, "Expression");
    }

    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction, SetFunction setFunction2) {
        throw Error.runtimeError(201, "Expression");
    }

    public Object getAggregatedValue(Session session, SetFunction setFunction) {
        throw Error.runtimeError(201, "Expression");
    }

    public Expression getCondition() {
        return null;
    }

    public boolean hasCondition() {
        return false;
    }

    public void setCondition(Expression expression) {
        throw Error.runtimeError(201, "Expression");
    }

    public void setCollation(Collation collation) {
        this.collation = collation;
    }
}

