/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;
import org.apache.geronimo.connector.outbound.AbstractSinglePoolConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;

public class SinglePoolMatchAllConnectionInterceptor
extends AbstractSinglePoolConnectionInterceptor {
    private final Map<ManagedConnection, ManagedConnectionInfo> pool;

    public SinglePoolMatchAllConnectionInterceptor(ConnectionInterceptor next, int maxSize, int minSize, int blockingTimeoutMilliseconds, int idleTimeoutMinutes) {
        super(next, maxSize, minSize, blockingTimeoutMilliseconds, idleTimeoutMinutes);
        this.pool = new IdentityHashMap<ManagedConnection, ManagedConnectionInfo>(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalGetConnection(ConnectionInfo connectionInfo) throws ResourceException {
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            ManagedConnectionInfo mci;
            ManagedConnectionFactory managedConnectionFactory;
            ManagedConnection matchedMC;
            if (this.destroyed) {
                throw new ResourceException("ManagedConnection pool has been destroyed");
            }
            if (!this.pool.isEmpty() && (matchedMC = (managedConnectionFactory = (mci = connectionInfo.getManagedConnectionInfo()).getManagedConnectionFactory()).matchManagedConnections(this.pool.keySet(), mci.getSubject(), mci.getConnectionRequestInfo())) != null) {
                connectionInfo.setManagedConnectionInfo(this.pool.get(matchedMC));
                this.pool.remove(matchedMC);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Supplying existing connection from pool " + this + " " + connectionInfo);
                }
                if (this.connectionCount < this.minSize) {
                    this.timer.schedule((TimerTask)new AbstractSinglePoolConnectionInterceptor.FillTask(connectionInfo), 10L);
                }
                return;
            }
            if (this.connectionCount == this.maxSize) {
                log.log(Level.FINEST, "Pool is at max size but no connections match, picking one to destroy");
                Iterator<Map.Entry<ManagedConnection, ManagedConnectionInfo>> iterator = this.pool.entrySet().iterator();
                ManagedConnectionInfo kill = iterator.next().getValue();
                iterator.remove();
                ConnectionInfo killInfo = new ConnectionInfo(kill);
                this.internalReturn(killInfo, ConnectionReturnAction.DESTROY);
            }
            this.next.getConnection(connectionInfo);
            ++this.connectionCount;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Supplying new connection from pool " + this + " " + connectionInfo);
            }
            if (this.connectionCount < this.minSize) {
                this.timer.schedule((TimerTask)new AbstractSinglePoolConnectionInterceptor.FillTask(connectionInfo), 10L);
            }
        }
    }

    @Override
    protected void doAdd(ManagedConnectionInfo mci) {
        this.pool.put(mci.getManagedConnection(), mci);
    }

    @Override
    protected Object getPool() {
        return this.pool;
    }

    @Override
    protected boolean doRemove(ManagedConnectionInfo mci) {
        return this.pool.remove(mci.getManagedConnection()) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalDestroy() {
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            for (ManagedConnection managedConnection : this.pool.keySet()) {
                try {
                    managedConnection.destroy();
                }
                catch (ResourceException resourceException) {}
            }
            this.pool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIdleConnectionCount() {
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            return this.pool.size();
        }
    }

    @Override
    protected void transferConnections(int maxSize, int shrinkNow) {
        ArrayList<ConnectionInfo> killList = new ArrayList<ConnectionInfo>(shrinkNow);
        Iterator<Map.Entry<ManagedConnection, ManagedConnectionInfo>> it = this.pool.entrySet().iterator();
        for (int i = 0; i < shrinkNow; ++i) {
            killList.add(new ConnectionInfo(it.next().getValue()));
        }
        for (ConnectionInfo killInfo : killList) {
            this.internalReturn(killInfo, ConnectionReturnAction.DESTROY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getExpiredManagedConnectionInfos(long threshold, List<ManagedConnectionInfo> killList) {
        Map<ManagedConnection, ManagedConnectionInfo> map = this.pool;
        synchronized (map) {
            Iterator<Map.Entry<ManagedConnection, ManagedConnectionInfo>> mcis = this.pool.entrySet().iterator();
            while (mcis.hasNext()) {
                ManagedConnectionInfo mci = mcis.next().getValue();
                if (mci.getLastUsed() >= threshold) continue;
                mcis.remove();
                killList.add(mci);
                --this.connectionCount;
            }
        }
    }

    @Override
    public void info(StringBuilder s) {
        s.append(this.getClass().getName());
        s.append("[minSize=").append(this.minSize);
        s.append(",maxSize=").append(this.maxSize);
        s.append(",idleTimeoutMilliseconds=").append(this.idleTimeoutMilliseconds);
        s.append(",blockingTimeoutMilliseconds=").append(this.blockingTimeoutMilliseconds).append("]\n");
        this.next.info(s);
    }
}

