/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

final class JsonDoubleImpl
implements JsonNumber,
Serializable {
    private final double value;
    private Integer hashCode = null;

    JsonDoubleImpl(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("double value must not be NaN or Infinite");
        }
        this.value = value;
    }

    public Number numberValue() {
        return this.value;
    }

    public boolean isIntegral() {
        return false;
    }

    public int intValue() {
        return (int)this.value;
    }

    public int intValueExact() {
        this.checkFractionalPart();
        return this.intValue();
    }

    public long longValue() {
        return (long)this.value;
    }

    public long longValueExact() {
        this.checkFractionalPart();
        return (long)this.value;
    }

    public BigInteger bigIntegerValue() {
        return new BigDecimal(this.toString()).toBigInteger();
    }

    public BigInteger bigIntegerValueExact() {
        return new BigDecimal(this.toString()).toBigIntegerExact();
    }

    public double doubleValue() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.toString());
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.bigDecimalValue().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (JsonDoubleImpl.class.isInstance(obj)) {
            return ((JsonDoubleImpl)JsonDoubleImpl.class.cast((Object)obj)).value == this.value;
        }
        return JsonNumber.class.isInstance(obj) && Objects.equals(((JsonNumber)JsonNumber.class.cast(obj)).bigDecimalValue(), this.bigDecimalValue());
    }

    private void checkFractionalPart() {
        if (this.value % 1.0 != 0.0) {
            throw new ArithmeticException("Not an int/long, use other value readers");
        }
    }
}

