/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactory;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactoryImpl;
import org.apache.fulcrum.jce.crypto.HexConverter;
import org.apache.fulcrum.jce.crypto.StreamUtil;

public final class CryptoUtil {
    public static void encrypt(Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        CryptoUtil.encrypt(CryptoUtil.getCryptoStreamFactory(), source, target, password);
    }

    public static void encrypt(CryptoStreamFactory factory, Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        InputStream is = StreamUtil.createInputStream(source);
        OutputStream os = StreamUtil.createOutputStream(target);
        OutputStream eos = factory.getOutputStream(os, password);
        StreamUtil.copy(is, eos);
    }

    public static void decrypt(Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        CryptoUtil.decrypt(CryptoUtil.getCryptoStreamFactory(), source, target, password);
    }

    public static void decrypt(CryptoStreamFactory factory, Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        InputStream is = StreamUtil.createInputStream(source);
        OutputStream os = StreamUtil.createOutputStream(target);
        InputStream dis = factory.getInputStream(is, password);
        StreamUtil.copy(dis, os);
    }

    public static String encryptString(String plainText, char[] password) throws GeneralSecurityException, IOException {
        return CryptoUtil.encryptString(CryptoUtil.getCryptoStreamFactory(), plainText, password);
    }

    public static String encryptString(CryptoStreamFactory factory, String plainText, char[] password) throws GeneralSecurityException, IOException {
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        CryptoUtil.encrypt(factory, plainText, bais, password);
        return HexConverter.toString(bais.toByteArray());
    }

    public static String decryptString(String cipherText, char[] password) throws GeneralSecurityException, IOException {
        return CryptoUtil.decryptString(CryptoUtil.getCryptoStreamFactory(), cipherText, password);
    }

    public static String decryptString(CryptoStreamFactory factory, String cipherText, char[] password) throws GeneralSecurityException, IOException {
        byte[] buffer = HexConverter.toBytes(cipherText);
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        CryptoUtil.decrypt(factory, buffer, bais, password);
        return new String(bais.toByteArray(), "utf-8");
    }

    public static long copy(InputStream is, OutputStream os) throws IOException {
        return StreamUtil.copy(is, os);
    }

    public static CryptoStreamFactory getCryptoStreamFactory() {
        return CryptoStreamFactoryImpl.getInstance();
    }
}

