/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.cache;

import java.lang.ref.SoftReference;
import java.util.Hashtable;
import ojb.broker.Identity;
import ojb.broker.cache.ObjectCache;
import ojb.broker.metadata.ClassNotPersistenceCapableException;

public class ObjectCacheDefaultImpl
implements ObjectCache {
    protected Hashtable objectTable = new Hashtable();
    private long hitCount = 0L;
    private long failCount = 0L;
    private long gcCount = 0L;

    public void cache(Object obj) throws ClassNotPersistenceCapableException {
        Identity oid = new Identity(obj);
        this.cache(oid, obj);
    }

    public void clear() {
        this.objectTable.clear();
    }

    public void cache(Identity oid, Object obj) {
        if (obj != null) {
            SoftReference<Object> ref = new SoftReference<Object>(obj);
            this.objectTable.put(oid.toString(), ref);
        }
    }

    public Object lookup(Identity oid) {
        ++this.hitCount;
        Object obj = null;
        SoftReference ref = (SoftReference)this.objectTable.get(oid.toString());
        if (ref != null) {
            obj = ref.get();
            if (obj == null) {
                ++this.gcCount;
                this.objectTable.remove(oid);
            }
        } else {
            ++this.failCount;
        }
        return obj;
    }

    public void remove(Identity oid) {
        this.objectTable.remove(oid.toString());
    }

    public void remove(Object obj) {
        this.objectTable.remove(new Identity(obj).toString());
    }

    public void finalize() {
        System.out.println("OJB CACHE STATISTICS");
        System.out.println("lookups:   " + this.hitCount);
        System.out.println("failures:  " + this.failCount);
        System.out.println("reclaimed: " + this.gcCount);
    }
}

