/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.metadata;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.metadata.JdbcConnectionDescriptor;
import ojb.broker.metadata.RepositoryXmlHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class DescriptorRepository {
    private static DescriptorRepository _instance;
    private static String _repositoryfile;
    private static boolean _debug;
    private Hashtable m_DescriptorTable = new Hashtable();
    private JdbcConnectionDescriptor m_DefaultConnectionDescriptor;

    private DescriptorRepository() {
        try {
            this.buildRepository(_repositoryfile);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static DescriptorRepository getInstance() {
        if (_instance == null) {
            _instance = new DescriptorRepository();
        }
        return _instance;
    }

    public static void setDebug(boolean b) {
        _debug = b;
    }

    public static void setRepositoryPath(String pathToRepository) {
        _repositoryfile = pathToRepository;
    }

    public String toString() {
        return "DescriptorRepository\n" + this.m_DefaultConnectionDescriptor + "\n" + this.m_DescriptorTable + "\n" + "";
    }

    public void setDefaultJdbcConnection(JdbcConnectionDescriptor jcd) {
        this.m_DefaultConnectionDescriptor = jcd;
    }

    public JdbcConnectionDescriptor getDefaultJdbcConnection() {
        return this.m_DefaultConnectionDescriptor;
    }

    public void put(Class c, ClassDescriptor cld) {
        this.m_DescriptorTable.put(c, cld);
    }

    public ClassDescriptor getDescriptorFor(Class c) throws ClassNotPersistenceCapableException {
        ClassDescriptor result = (ClassDescriptor)this.m_DescriptorTable.get(c);
        if (result == null) {
            throw new ClassNotPersistenceCapableException(c.getName() + " not found in OJB Repository");
        }
        return result;
    }

    public Class getExtentClass(Class clazz) {
        Iterator iter = this.m_DescriptorTable.values().iterator();
        while (iter.hasNext()) {
            ClassDescriptor cld = (ClassDescriptor)iter.next();
            if (!cld.getExtentClasses().contains(clazz)) continue;
            return cld.getClassOfObject();
        }
        return clazz;
    }

    private DescriptorRepository(String repositoryFileName) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        this.buildRepository(repositoryFileName);
    }

    private void buildRepository(String repositoryFileName) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        File f = new File(repositoryFileName);
        String xmlfile = f.toURL().toString();
        System.out.println("OJB Descriptor Repository: " + xmlfile);
        SAXParserFactory saxFact = SAXParserFactory.newInstance();
        saxFact.setValidating(true);
        Parser parser = saxFact.newSAXParser().getParser();
        RepositoryXmlHandler handler = new RepositoryXmlHandler(this);
        parser.setDocumentHandler(handler);
        parser.parse(xmlfile);
        if (_debug) {
            System.out.println("...Finished parsing");
        }
    }

    public static DescriptorRepository getInstance(String repositoryFileName) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        if (_instance == null) {
            _instance = new DescriptorRepository(repositoryFileName);
        }
        return _instance;
    }

    static {
        _repositoryfile = "repository.xml";
        _debug = false;
    }
}

