/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.metadata;

import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import ojb.broker.accesslayer.ConversionStrategy;
import ojb.broker.accesslayer.RowReader;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.CollectionDescriptor;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.metadata.JdbcConnectionDescriptor;
import ojb.broker.metadata.ObjectReferenceDescriptor;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RepositoryXmlHandler
extends HandlerBase {
    private static boolean _debug = false;
    private int defIsoLevel = 0;
    private DescriptorRepository m_repository;
    private JdbcConnectionDescriptor m_CurrentJCD;
    private ClassDescriptor m_CurrentCLD;
    private FieldDescriptor m_CurrentFLD;
    private ObjectReferenceDescriptor m_CurrentORD;
    private CollectionDescriptor m_CurrentCOD;
    private String m_CurrentString;
    private static final Hashtable LiteralsMap = RepositoryXmlHandler.buildLiteralsMap();

    public static void setDebug(boolean b) {
        _debug = b;
    }

    private static int getLiteralId(String literal) {
        return (Integer)LiteralsMap.get(literal);
    }

    public RepositoryXmlHandler(DescriptorRepository dr) {
        this.m_repository = dr;
    }

    public void startDocument() {
        if (_debug) {
            System.out.println("startDoc");
        }
    }

    public void endDocument() {
        if (_debug) {
            System.out.println(this.m_repository);
        }
        if (_debug) {
            System.out.println("endDoc");
        }
    }

    public void startElement(String name, AttributeList atts) {
        this.m_CurrentString = null;
        try {
            switch (RepositoryXmlHandler.getLiteralId(name)) {
                case 0: {
                    String defIso;
                    if (this.m_repository == null) {
                        this.m_repository = DescriptorRepository.getInstance();
                    }
                    if ((defIso = atts.getValue("isolation")) != null) {
                        this.defIsoLevel = this.getIsoLevel(defIso);
                    }
                    if (!_debug) break;
                    System.out.println(" > MappingRepository");
                    break;
                }
                case 1: {
                    if (_debug) {
                        System.out.println("   > JdbcConnectionDescription");
                    }
                    this.m_CurrentJCD = new JdbcConnectionDescriptor();
                    if (this.m_CurrentCLD == null) {
                        this.m_repository.setDefaultJdbcConnection(this.m_CurrentJCD);
                        break;
                    }
                    this.m_CurrentCLD.setConnectionDescriptor(this.m_CurrentJCD);
                    break;
                }
                case 12: {
                    if (_debug) {
                        System.out.println("  > ClassDescriptor");
                    }
                    String isoLevel = atts.getValue("isolation");
                    this.m_CurrentCLD = new ClassDescriptor();
                    if (isoLevel != null) {
                        this.m_CurrentCLD.setIsolationLevel(this.getIsoLevel(isoLevel));
                        break;
                    }
                    this.m_CurrentCLD.setIsolationLevel(this.defIsoLevel);
                    break;
                }
                case 15: {
                    if (_debug) {
                        System.out.println("    > FieldDescriptor");
                    }
                    int id = Integer.parseInt(atts.getValue("id"));
                    this.m_CurrentFLD = new FieldDescriptor(id);
                    this.m_CurrentCLD.addFieldDescriptor(this.m_CurrentFLD);
                    break;
                }
                case 20: {
                    if (_debug) {
                        System.out.println("    > ReferenceDescriptor");
                    }
                    this.m_CurrentORD = new ObjectReferenceDescriptor();
                    this.m_CurrentCLD.addObjectReferenceDescriptor(this.m_CurrentORD);
                    break;
                }
                case 27: {
                    if (_debug) {
                        System.out.println("    > CollectionDescriptor");
                    }
                    this.m_CurrentCOD = new CollectionDescriptor();
                    this.m_CurrentCLD.addCollectionDescriptor(this.m_CurrentCOD);
                    break;
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void endElement(String name) {
        try {
            switch (RepositoryXmlHandler.getLiteralId(name)) {
                case 0: {
                    if (_debug) {
                        System.out.println(" < MappingRepository");
                    }
                    break;
                }
                case 1: {
                    if (_debug) {
                        System.out.println("   < JdbcConnectionDescription");
                    }
                    break;
                }
                case 2: {
                    if (_debug) {
                        System.out.println("     dbms.name: " + this.m_CurrentString);
                    }
                    this.m_CurrentJCD.setDbms(this.m_CurrentString);
                    break;
                }
                case 5: {
                    if (_debug) {
                        System.out.println("     schema.name: " + this.m_CurrentString);
                    }
                    if (this.m_CurrentString != "") {
                        this.m_CurrentJCD.setScheme(this.m_CurrentString);
                    }
                    break;
                }
                case 6: {
                    if (_debug) {
                        System.out.println("     driver.name: " + this.m_CurrentString);
                    }
                    this.m_CurrentJCD.setDriver(this.m_CurrentString);
                    break;
                }
                case 7: {
                    if (_debug) {
                        System.out.println("     url.protocol: " + this.m_CurrentString);
                    }
                    this.m_CurrentJCD.setProtocol(this.m_CurrentString);
                    break;
                }
                case 8: {
                    if (_debug) {
                        System.out.println("     url.subprotocol: " + this.m_CurrentString);
                    }
                    this.m_CurrentJCD.setSubProtocol(this.m_CurrentString);
                    break;
                }
                case 9: {
                    if (_debug) {
                        System.out.println("     url.dbalias: " + this.m_CurrentString);
                    }
                    this.m_CurrentJCD.setDbAlias(this.m_CurrentString);
                    break;
                }
                case 10: {
                    if (_debug) {
                        System.out.println("     user.name: " + this.m_CurrentString);
                    }
                    this.m_CurrentJCD.setUserName(this.m_CurrentString);
                    break;
                }
                case 11: {
                    if (_debug) {
                        System.out.println("     user.passwd: " + this.m_CurrentString);
                    }
                    this.m_CurrentJCD.setPassWord(this.m_CurrentString);
                    break;
                }
                case 12: {
                    if (_debug) {
                        System.out.println("  < ClassDescriptor");
                    }
                    this.m_CurrentCLD = null;
                    break;
                }
                case 13: {
                    if (_debug) {
                        System.out.println("     class.name: " + this.m_CurrentString);
                    }
                    try {
                        Class<?> c = Class.forName(this.m_CurrentString);
                        this.m_CurrentCLD.setClassOfObject(c);
                        this.m_repository.put(c, this.m_CurrentCLD);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                case 35: {
                    if (_debug) {
                        System.out.println("     class.proxy: " + this.m_CurrentString);
                    }
                    if (this.m_CurrentString.equals("dynamic")) {
                        Class pc = this.getDynamicProxyClass(this.m_CurrentCLD);
                        this.m_CurrentCLD.setProxyClass(pc);
                        break;
                    }
                    Class<?> pc = Class.forName(this.m_CurrentString);
                    this.m_CurrentCLD.setProxyClass(pc);
                    break;
                }
                case 33: {
                    if (_debug) {
                        System.out.println("     class.extend: " + this.m_CurrentString);
                    }
                    Class<?> ec = Class.forName(this.m_CurrentString);
                    this.m_CurrentCLD.addExtentClass(ec);
                    break;
                }
                case 34: {
                    if (_debug) {
                        System.out.println("     ExtendDescriptor: " + this.m_CurrentString);
                    }
                    this.m_CurrentCLD.setIsInterface(true);
                    break;
                }
                case 14: {
                    if (_debug) {
                        System.out.println("     table.name: " + this.m_CurrentString);
                    }
                    this.m_CurrentCLD.setTableName(this.m_CurrentString);
                    break;
                }
                case 36: {
                    if (_debug) {
                        System.out.println("     orderby: " + this.m_CurrentString);
                    }
                    this.m_CurrentCLD.setOrderby(this.m_CurrentString);
                    break;
                }
                case 30: {
                    if (_debug) {
                        System.out.println("     conversionStrategy: " + this.m_CurrentString);
                    }
                    this.m_CurrentCLD.setConversionStrategy((ConversionStrategy)Class.forName(this.m_CurrentString).newInstance());
                    break;
                }
                case 32: {
                    if (_debug) {
                        System.out.println("     rowReader: " + this.m_CurrentString);
                    }
                    this.m_CurrentCLD.setRowReader((RowReader)Class.forName(this.m_CurrentString).newInstance());
                    break;
                }
                case 15: {
                    if (_debug) {
                        System.out.println("    < FieldDescriptor");
                    }
                    this.m_CurrentFLD = null;
                    break;
                }
                case 16: {
                    if (_debug) {
                        System.out.println("     field.name: " + this.m_CurrentString);
                    }
                    Class c = this.m_CurrentCLD.getClassOfObject();
                    this.m_CurrentFLD.setPersistentField(c, this.m_CurrentString);
                    break;
                }
                case 17: {
                    if (_debug) {
                        System.out.println("     column.name: " + this.m_CurrentString);
                    }
                    this.m_CurrentFLD.setColumnName(this.m_CurrentString);
                    break;
                }
                case 18: {
                    if (_debug) {
                        System.out.println("     jdbc_type: " + this.m_CurrentString);
                    }
                    this.m_CurrentFLD.setColumnType(this.m_CurrentString);
                    break;
                }
                case 19: {
                    if (_debug) {
                        System.out.println("     PrimaryKey: " + this.m_CurrentString);
                    }
                    boolean b = new Boolean(this.m_CurrentString);
                    this.m_CurrentFLD.setPrimaryKey(b);
                    break;
                }
                case 31: {
                    if (_debug) {
                        System.out.println("     autoincrement: " + this.m_CurrentString);
                    }
                    boolean b = new Boolean(this.m_CurrentString);
                    this.m_CurrentFLD.setAutoIncrement(b);
                    break;
                }
                case 20: {
                    if (_debug) {
                        System.out.println("    < ReferenceDescriptor");
                    }
                    this.m_CurrentORD = null;
                    break;
                }
                case 21: {
                    if (_debug) {
                        System.out.println("     rdfield.name: " + this.m_CurrentString);
                    }
                    this.m_CurrentORD.setPersistentField(this.m_CurrentCLD.getClassOfObject(), this.m_CurrentString);
                    break;
                }
                case 22: {
                    if (_debug) {
                        System.out.println("     referenced.class: " + this.m_CurrentString);
                    }
                    this.m_CurrentORD.setItemClass(Class.forName(this.m_CurrentString));
                    break;
                }
                case 23: {
                    if (_debug) {
                        System.out.println("     descriptor_ids: " + this.m_CurrentString);
                    }
                    Vector<Integer> v = new Vector<Integer>();
                    StringTokenizer st = new StringTokenizer(this.m_CurrentString, " ");
                    while (st.hasMoreTokens()) {
                        Integer FieldIndex = new Integer(st.nextToken());
                        v.add(FieldIndex);
                    }
                    if (this.m_CurrentCOD != null) {
                        this.m_CurrentCOD.setForeignKeyFields(v);
                        break;
                    }
                    this.m_CurrentORD.setForeignKeyFields(v);
                    break;
                }
                case 24: {
                    if (_debug) {
                        System.out.println("     auto.retrieve: " + this.m_CurrentString);
                    }
                    boolean b = new Boolean(this.m_CurrentString);
                    if (this.m_CurrentCOD != null) {
                        this.m_CurrentCOD.setCascadeRetrieve(b);
                        break;
                    }
                    this.m_CurrentORD.setCascadeRetrieve(b);
                    break;
                }
                case 25: {
                    if (_debug) {
                        System.out.println("     auto.update: " + this.m_CurrentString);
                    }
                    boolean b = new Boolean(this.m_CurrentString);
                    if (this.m_CurrentCOD != null) {
                        this.m_CurrentCOD.setCascadeStore(b);
                        break;
                    }
                    this.m_CurrentORD.setCascadeStore(b);
                    break;
                }
                case 26: {
                    if (_debug) {
                        System.out.println("     auto.delete: " + this.m_CurrentString);
                    }
                    boolean b = new Boolean(this.m_CurrentString);
                    if (this.m_CurrentCOD != null) {
                        this.m_CurrentCOD.setCascadeDelete(b);
                        break;
                    }
                    this.m_CurrentORD.setCascadeDelete(b);
                    break;
                }
                case 27: {
                    if (_debug) {
                        System.out.println("    < CollectionDescriptor");
                    }
                    this.m_CurrentCOD = null;
                    break;
                }
                case 28: {
                    if (_debug) {
                        System.out.println("     cdfield.name: " + this.m_CurrentString);
                    }
                    this.m_CurrentCOD.setPersistentField(this.m_CurrentCLD.getClassOfObject(), this.m_CurrentString);
                    break;
                }
                case 29: {
                    if (_debug) {
                        System.out.println("     items.class: " + this.m_CurrentString);
                    }
                    this.m_CurrentCOD.setItemClass(Class.forName(this.m_CurrentString));
                    break;
                }
                case 37: {
                    if (_debug) {
                        System.out.println("     collection.class: " + this.m_CurrentString);
                    }
                    this.m_CurrentCOD.setCollectionClass(Class.forName(this.m_CurrentString));
                    break;
                }
                default: {
                    System.out.println("Ignoring unknown Element " + name);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.m_CurrentString = this.m_CurrentString == null ? new String(ch, start, length) : this.m_CurrentString + new String(ch, start, length);
    }

    public void error(SAXParseException e) throws SAXException {
        System.out.println(e.getMessage());
        e.printStackTrace();
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.out.println(e.getMessage());
        e.printStackTrace();
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        System.out.println(e.getMessage());
        e.printStackTrace();
    }

    private static final Hashtable buildLiteralsMap() {
        int LiteralCount = 40;
        Hashtable<String, Integer> table = new Hashtable<String, Integer>((int)(1.0 + (double)LiteralCount / 0.75));
        table.put("MappingRepository", new Integer(0));
        table.put("JdbcConnectionDescriptor", new Integer(1));
        table.put("dbms.name", new Integer(2));
        table.put("dbms.hostname", new Integer(3));
        table.put("dbms.port", new Integer(4));
        table.put("schema.name", new Integer(5));
        table.put("driver.name", new Integer(6));
        table.put("url.protocol", new Integer(7));
        table.put("url.subprotocol", new Integer(8));
        table.put("url.dbalias", new Integer(9));
        table.put("user.name", new Integer(10));
        table.put("user.passwd", new Integer(11));
        table.put("ClassDescriptor", new Integer(12));
        table.put("class.name", new Integer(13));
        table.put("class.proxy", new Integer(35));
        table.put("class.extent", new Integer(33));
        table.put("table.name", new Integer(14));
        table.put("orderby", new Integer(36));
        table.put("conversionStrategy", new Integer(30));
        table.put("rowReader", new Integer(32));
        table.put("FieldDescriptor", new Integer(15));
        table.put("field.name", new Integer(16));
        table.put("column.name", new Integer(17));
        table.put("jdbc_type", new Integer(18));
        table.put("PrimaryKey", new Integer(19));
        table.put("autoincrement", new Integer(31));
        table.put("ReferenceDescriptor", new Integer(20));
        table.put("rdfield.name", new Integer(21));
        table.put("referenced.class", new Integer(22));
        table.put("descriptor_ids", new Integer(23));
        table.put("auto.retrieve", new Integer(24));
        table.put("auto.update", new Integer(25));
        table.put("auto.delete", new Integer(26));
        table.put("CollectionDescriptor", new Integer(27));
        table.put("cdfield.name", new Integer(28));
        table.put("items.class", new Integer(29));
        table.put("collection.class", new Integer(37));
        table.put("ExtentDescriptor", new Integer(34));
        table.put("38", new Integer(38));
        table.put("39", new Integer(39));
        return table;
    }

    private int getIsoLevel(String isoLevel) {
        if (isoLevel.equals("read-uncommitted")) {
            return 0;
        }
        if (isoLevel.equals("read-committed")) {
            return 1;
        }
        if (isoLevel.equals("repeatable-read")) {
            return 2;
        }
        if (isoLevel.equals("serializable")) {
            return 3;
        }
        System.out.println("OJB Warning: unknown isolation-level: " + isoLevel + " using RW_UNCOMMITTED as default");
        return this.defIsoLevel;
    }

    private Class getDynamicProxyClass(ClassDescriptor cld) {
        Class clazz = cld.getClassOfObject();
        try {
            Class<?>[] interfaces = clazz.getInterfaces();
            Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), interfaces);
            return proxyClass;
        }
        catch (Throwable t) {
            System.out.println("OJB Warning: can not use dynamic proxy for class " + clazz.getName() + ": " + t.getMessage());
            return null;
        }
    }
}

