/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import ojb.broker.ManageableCollection;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.query.Criteria;
import ojb.broker.query.CriteriaException;
import ojb.broker.query.Query;
import ojb.broker.query.QueryByCriteria;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import ojb.odmg.collections.DListEntry;
import ojb.odmg.collections.DListIterator;
import ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.OQLQuery;
import org.odmg.QueryInvalidException;
import org.odmg.Transaction;

public class DListImpl
extends AbstractList
implements DList,
DArray,
ManageableCollection,
Serializable {
    private int id;
    private Vector elements;
    private int size;
    static /* synthetic */ Class class$ojb$odmg$collections$DListImpl;

    public DListImpl() {
        this.elements = new Vector();
        this.id = this.generateNewId();
        this.size = 0;
    }

    public DListImpl(int theId, int theSize) {
        this.id = theId;
        this.size = theSize;
    }

    public void add(int index, Object element) {
        ++this.size;
        DListEntry entry = new DListEntry(this, element);
        this.elements.add(index, entry);
        TransactionImpl tx = this.getCurrentTransaction();
        if (tx != null) {
            tx.lock(this, 4);
            tx.lock(entry, 4);
            tx.lock(element, 1);
        }
        int offset = 0;
        try {
            offset = ((DListEntry)this.elements.get(index - 1)).getPosition();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        int i = offset;
        while (i < this.elements.size()) {
            entry = (DListEntry)this.elements.get(i);
            entry.setPosition(i);
            ++i;
        }
    }

    public Object remove(int index) {
        DListEntry entry = (DListEntry)this.elements.get(index);
        TransactionImpl tx = this.getCurrentTransaction();
        if (tx != null) {
            tx.markDelete(entry);
        }
        return entry.getRealSubject();
    }

    private TransactionImpl getCurrentTransaction() {
        return (TransactionImpl)OJB.getInstance().currentTransaction();
    }

    public DList concat(DList otherList) {
        DListImpl result = new DListImpl();
        result.addAll(this);
        result.addAll(otherList);
        return result;
    }

    public boolean existsElement(String predicate) throws QueryInvalidException {
        DList results = (DList)this.query(predicate);
        return results != null && results.size() != 0;
    }

    private int generateNewId() {
        PersistenceBroker broker = PersistenceBrokerFactory.createPersistenceBroker();
        try {
            return broker.getUniqueId(this.getClass(), "id");
        }
        catch (PersistenceBrokerException e) {
            return -1;
        }
    }

    public Object get(int index) {
        DListEntry entry = (DListEntry)this.elements.get(index);
        return entry.getRealSubject();
    }

    Vector getElements() {
        return this.elements;
    }

    int getId() {
        return this.id;
    }

    public Iterator iterator() {
        return new DListIterator(this);
    }

    public ListIterator listIterator() {
        return new DListIterator(this);
    }

    public ListIterator listIterator(int index) {
        return new DListIterator(this, index);
    }

    private Criteria getPkCriteriaForAllElements() {
        try {
            Criteria crit = null;
            int i = 0;
            while (i < this.elements.size()) {
                DListEntry entry = (DListEntry)this.elements.get(i);
                Object obj = entry.getRealSubject();
                ClassDescriptor cld = DescriptorRepository.getInstance().getDescriptorFor(obj.getClass());
                FieldDescriptor[] pkFields = cld.getPkFields();
                Object[] pkValues = cld.getKeyValues(obj);
                Criteria criteria = new Criteria();
                int j = 0;
                while (j < pkFields.length) {
                    FieldDescriptor fld = pkFields[j];
                    criteria.addEqualTo(fld.getPersistentField().getName(), pkValues[j]);
                    ++j;
                }
                try {
                    if (crit == null) {
                        crit = criteria;
                    } else {
                        crit.addOrCriteria(criteria);
                    }
                }
                catch (CriteriaException e) {
                    // empty catch block
                }
                ++i;
            }
            return crit;
        }
        catch (ClassNotPersistenceCapableException e) {
            return null;
        }
    }

    private Class getElementsExtentClass() {
        DListEntry entry = (DListEntry)this.elements.get(0);
        Class<?> elementsClass = entry.getRealSubject().getClass();
        Class extentClass = DescriptorRepository.getInstance().getExtentClass(elementsClass);
        return extentClass;
    }

    public DCollection query(String predicate) throws QueryInvalidException {
        String oql = "select all from java.lang.Object where " + predicate;
        OQLQuery predicateQuery = OJB.getInstance().newOQLQuery();
        predicateQuery.create(oql);
        Query pQ = ((OQLQueryImpl)predicateQuery).getQuery();
        Criteria pCrit = pQ.getCriteria();
        Criteria allElementsCriteria = this.getPkCriteriaForAllElements();
        allElementsCriteria.addAndCriteria(pCrit);
        Class clazz = this.getElementsExtentClass();
        QueryByCriteria q = new QueryByCriteria(clazz, allElementsCriteria);
        System.out.println(((Object)q).toString());
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        Transaction tx = OJB.getInstance().currentTransaction();
        boolean needsCommit = false;
        if (tx == null) {
            tx = OJB.getInstance().newTransaction();
            tx.begin();
            needsCommit = true;
        }
        DListImpl result = null;
        try {
            result = (DListImpl)broker.getCollectionByQuery(class$ojb$odmg$collections$DListImpl == null ? (class$ojb$odmg$collections$DListImpl = DListImpl.class$("ojb.odmg.collections.DListImpl")) : class$ojb$odmg$collections$DListImpl, q);
        }
        catch (PersistenceBrokerException e) {
            // empty catch block
        }
        if (needsCommit) {
            tx.commit();
        }
        return result;
    }

    public Iterator select(String predicate) throws QueryInvalidException {
        return this.query(predicate).iterator();
    }

    public Object selectElement(String predicate) throws QueryInvalidException {
        return ((DList)this.query(predicate)).get(0);
    }

    public int size() {
        return this.elements.size();
    }

    public void ojbAdd(Object anObject) {
        ++this.size;
        DListEntry entry = new DListEntry(this, anObject);
        entry.setPosition(this.elements.size());
        this.elements.add(entry);
    }

    public void ojbAddAll(ManageableCollection otherCollection) {
        this.addAll((DListImpl)otherCollection);
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void resize(int newSize) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

