/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerDigester;

public class MessengerManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messenger$MessengerManager == null ? (class$org$apache$commons$messenger$MessengerManager = MessengerManager.class$("org.apache.commons.messenger.MessengerManager")) : class$org$apache$commons$messenger$MessengerManager));
    private static MessengerManager singleton;
    private Map messengers = new Hashtable();
    static /* synthetic */ Class class$org$apache$commons$messenger$MessengerManager;

    public static Messenger get(String name) throws JMSException {
        return MessengerManager.getInstance().getMessenger(name);
    }

    public static MessengerManager load(String xmlURL) throws JMSException {
        try {
            MessengerDigester digester = new MessengerDigester();
            return (MessengerManager)digester.parse(xmlURL);
        }
        catch (Exception e) {
            JMSException newException = new JMSException("Could not load the Messenger XML config file from: " + xmlURL + ". Underlying reason: " + e);
            newException.setLinkedException(e);
            throw newException;
        }
    }

    public static void configure(String xmlURL) throws JMSException {
        MessengerManager.setInstance(MessengerManager.load(xmlURL));
    }

    public Messenger getMessenger(String name) {
        return (Messenger)this.messengers.get(name);
    }

    public void addMessenger(Messenger messenger) {
        this.messengers.put(messenger.getName(), messenger);
    }

    public void removeMessenger(Messenger messenger) {
        this.messengers.remove(messenger.getName());
    }

    public Iterator getMessengerNames() {
        return this.messengers.keySet().iterator();
    }

    public static synchronized MessengerManager getInstance() throws JMSException {
        if (singleton == null) {
            singleton = MessengerManager.createInstance();
        }
        return singleton;
    }

    public static void setInstance(MessengerManager messengerManager) {
        singleton = messengerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = this.messengers;
        synchronized (map) {
            Iterator iter = this.messengers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = entry.getKey().toString();
                Messenger messenger = (Messenger)entry.getValue();
                iter.remove();
                try {
                    messenger.close();
                }
                catch (Exception e) {
                    log.error((Object)("Caught exception trying to close messenger: " + name + " Exception: " + e), (Throwable)e);
                }
            }
        }
    }

    protected static MessengerManager createInstance() throws JMSException {
        String config = null;
        try {
            config = System.getProperty("org.apache.commons.messenger");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (config != null) {
            return MessengerManager.load(config);
        }
        URL url = (class$org$apache$commons$messenger$MessengerManager == null ? (class$org$apache$commons$messenger$MessengerManager = MessengerManager.class$("org.apache.commons.messenger.MessengerManager")) : class$org$apache$commons$messenger$MessengerManager).getClassLoader().getResource("Messenger.xml");
        if (url == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            url = loader.getResource("Messenger.xml");
        }
        if (url != null) {
            return MessengerManager.load(url.toString());
        }
        throw new JMSException("No Messenger.xml configuration document found on the CLASSPATH. Could not initialise the default MessengerManager!!");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

