/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.naming;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.naming.NamingService;
import org.apache.turbine.util.RunData;

public class TurbineNamingService
extends TurbineBaseService
implements NamingService {
    private static Log log = LogFactory.getLog((Class)TurbineNamingService.class);
    private Map contextPropsList = null;
    private Map initialContexts = new HashMap();

    public void init() throws InitializationException {
        Configuration conf = Turbine.getConfiguration();
        try {
            String key;
            this.contextPropsList = new HashMap();
            Iterator contextKeys = conf.subset("context").getKeys();
            while (contextKeys.hasNext()) {
                key = (String)contextKeys.next();
                int end = key.indexOf(".");
                if (end == -1) continue;
                String contextName = key.substring(0, end);
                Properties contextProps = null;
                contextProps = this.contextPropsList.containsKey(contextName) ? (Properties)this.contextPropsList.get(contextName) : new Properties();
                contextProps.put(key.substring(end + 1), conf.getString(key));
                this.contextPropsList.put(contextName, contextProps);
            }
            Iterator contextPropsKeys = this.contextPropsList.keySet().iterator();
            while (contextPropsKeys.hasNext()) {
                key = (String)contextPropsKeys.next();
                Properties contextProps = (Properties)this.contextPropsList.get(key);
                InitialContext context = new InitialContext(contextProps);
                this.initialContexts.put(key, context);
            }
            this.setInit(true);
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize JDNI contexts!", (Throwable)e);
            throw new InitializationException("Failed to initialize JDNI contexts!");
        }
    }

    public void init(RunData data) throws InitializationException {
        try {
            if (this.contextPropsList == null) {
                this.init();
            }
            Iterator it = this.contextPropsList.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Properties contextProps = (Properties)this.contextPropsList.get(key);
                InitialContext context = new InitialContext(contextProps);
                data.getJNDIContexts().put(key, context);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize JDNI contexts!", (Throwable)e);
            throw new InitializationException("Failed to initialize JDNI contexts!");
        }
    }

    public Context getContext(String contextName) {
        Properties contextProps = null;
        contextProps = this.contextPropsList.containsKey(contextName) ? (Properties)this.contextPropsList.get(contextName) : new Properties();
        try {
            return new InitialContext(contextProps);
        }
        catch (Exception e) {
            return null;
        }
    }
}

