/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.util.ServerData;

public class ServletUtils {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final int FTP_PORT = 20;
    public static final String URI_SCHEME_SEPARATOR = "://";

    public static String expandRelative(ServletConfig config, String text) {
        ServletContext context;
        String base;
        if (StringUtils.isEmpty((String)text)) {
            return text;
        }
        if (config == null) {
            return null;
        }
        if (!(text.startsWith("/") || text.startsWith("./") || text.startsWith("\\") || text.startsWith(".\\"))) {
            StringBuffer sb = new StringBuffer();
            sb.append("./");
            sb.append(text);
            text = sb.toString();
        }
        String string = base = StringUtils.isEmpty((String)(base = (context = config.getServletContext()).getRealPath("/"))) ? config.getInitParameter("basedir") : base;
        if (StringUtils.isEmpty((String)base)) {
            return text;
        }
        String separator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(text, separator);
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            buffer.append(base).append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static StringBuffer hostURL(HttpServletRequest req) {
        return ServletUtils.hostURL(req, null);
    }

    public static StringBuffer hostURL(HttpServletRequest req, String scheme) {
        ServerData serverData = new ServerData(req);
        if (StringUtils.isNotEmpty((String)scheme)) {
            serverData.setServerScheme(scheme);
        }
        StringBuffer sb = new StringBuffer();
        serverData.getHostUrl(sb);
        return sb;
    }
}

