/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.template;

import org.apache.ecs.Element;
import org.apache.ecs.html.Option;
import org.apache.ecs.html.Select;

public class SelectorBox {
    private Select sel = null;
    private int size = 1;
    private String name = null;
    private Object[] names = null;
    private Object[] values = null;
    private boolean[] selected = null;

    public SelectorBox(String name, Object[] names, Object[] values) {
        this(name, names, values, 1, null);
    }

    public SelectorBox(String name, Object[] names, Object[] values, int size) {
        this(name, names, values, size, null);
    }

    public SelectorBox(String name, Object[] names, Object[] values, boolean[] selected) {
        this(name, names, values, 1, selected);
    }

    public SelectorBox(String name, Object[] names, Object[] values, int size, boolean[] selected) {
        this.name = name;
        this.names = names;
        this.values = values;
        this.size = size;
        this.selected = selected;
        this.sel = new Select(name, size);
        this.sel.setName(name);
        this.sel.setSize(size);
    }

    public void buildBooleans(Object[] selectedSet, Object[] entireSet) {
        this.selected = new boolean[entireSet.length];
        for (int j = 0; j < entireSet.length; ++j) {
            Object r2 = entireSet[j];
            for (int i = 0; i < selectedSet.length; ++i) {
                Object r1 = selectedSet[i];
                if (r1 == null || r2 == null || !r1.toString().equalsIgnoreCase(r2.toString())) continue;
                this.selected[j] = true;
            }
        }
    }

    public String toString(int size) {
        this.sel.setSize(size);
        this.sel.setName(this.name);
        for (int f = 0; f < this.values.length; ++f) {
            Option opt = new Option((String)this.values[f]);
            opt.addElement((String)this.names[f]);
            if (this.selected != null && this.selected[f]) {
                opt.setSelected(true);
            }
            this.sel.addElement((Element)opt);
        }
        String output = this.sel.toString();
        this.reset();
        return output;
    }

    public void reset() {
        this.sel = new Select(this.name, this.size);
    }

    public String toString() {
        return this.toString(this.size);
    }

    public SelectorBox setMultiple(boolean val) {
        this.sel.setMultiple(val);
        return this;
    }

    public SelectorBox setName(String name) {
        this.name = name;
        this.sel.setName(name);
        return this;
    }

    public SelectorBox setSize(int size) {
        this.size = size;
        this.sel.setSize(size);
        return this;
    }

    public SelectorBox setOnChange(String script) {
        this.sel.setOnChange(script);
        return this;
    }

    public SelectorBox setSelected(boolean[] bools) {
        this.selected = bools;
        return this;
    }

    public SelectorBox setSelected(Object name) {
        if (name != null) {
            this.selected = new boolean[this.names.length];
            for (int i = 0; i < this.names.length; ++i) {
                Object o = this.names[i];
                if (o == null || !o.toString().equalsIgnoreCase(name.toString())) continue;
                this.selected[i] = true;
            }
        }
        return this;
    }
}

