/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.ListIterator;
import org.apache.torque.adapter.AbstractDBAdapter;
import org.apache.torque.util.Query;
import org.apache.torque.util.UniqueList;

public class DBOracle
extends AbstractDBAdapter {
    private static final long serialVersionUID = 8966976210230241194L;
    private static final String DATE_FORMAT = "dd-MM-yyyy HH:mm:ss";

    protected DBOracle() {
    }

    public String toUpperCase(String in) {
        return "UPPER(" + in + ")";
    }

    public String ignoreCase(String in) {
        return "UPPER(" + in + ")";
    }

    public String getDateString(Date date) {
        return "TO_DATE('" + new SimpleDateFormat(DATE_FORMAT).format(date) + "', 'DD-MM-YYYY HH24:MI:SS')";
    }

    public String getIDMethodType() {
        return "sequence";
    }

    public String getIDMethodSQL(Object sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public void lockTable(Connection con, String table) throws SQLException {
        Statement statement = con.createStatement();
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT next_id FROM ").append(table).append(" FOR UPDATE");
        statement.executeQuery(stmt.toString());
    }

    public void unlockTable(Connection con, String table) throws SQLException {
        con.commit();
    }

    public int getLimitStyle() {
        return 4;
    }

    public boolean supportsNativeLimit() {
        return true;
    }

    public boolean supportsNativeOffset() {
        return true;
    }

    public void generateLimits(Query query, int offset, int limit) {
        String selectColumn;
        StringBuffer preLimit = new StringBuffer().append("SELECT B.* FROM ( ").append("SELECT A.*, rownum AS TORQUE$ROWNUM FROM ( ");
        StringBuffer postLimit = new StringBuffer().append(" ) A ").append(" ) B WHERE ");
        if (offset > 0) {
            postLimit.append(" B.TORQUE$ROWNUM > ").append(offset);
            if (limit >= 0) {
                postLimit.append(" AND B.TORQUE$ROWNUM <= ").append(offset + limit);
            }
        } else {
            postLimit.append(" B.TORQUE$ROWNUM <= ").append(limit);
        }
        query.setPreLimit(preLimit.toString());
        query.setPostLimit(postLimit.toString());
        query.setLimit(null);
        UniqueList selectColumns = query.getSelectClause();
        int replacementSuffix = 0;
        HashSet<String> columnNames = new HashSet<String>();
        ListIterator<String> columnIt = selectColumns.listIterator();
        while (columnIt.hasNext()) {
            int spacePos;
            selectColumn = (String)columnIt.next();
            if (selectColumn.indexOf(40) != -1 || selectColumn.indexOf(41) != -1 || (spacePos = selectColumn.lastIndexOf(32)) == -1) continue;
            String aliasName = selectColumn.substring(spacePos + 1);
            columnNames.add(aliasName);
        }
        columnIt = selectColumns.listIterator();
        while (columnIt.hasNext()) {
            int spacePos;
            selectColumn = (String)columnIt.next();
            if (selectColumn.indexOf(40) != -1 || selectColumn.indexOf(41) != -1 || (spacePos = selectColumn.lastIndexOf(32)) != -1) continue;
            int dotPos = selectColumn.lastIndexOf(46);
            String column = dotPos != -1 ? selectColumn.substring(dotPos + 1) : selectColumn;
            if (columnNames.contains(column)) {
                String aliasName;
                do {
                    aliasName = "a" + replacementSuffix;
                    ++replacementSuffix;
                } while (columnNames.contains(aliasName));
                selectColumn = selectColumn + " " + aliasName;
                columnIt.set(selectColumn);
                columnNames.add(aliasName);
                continue;
            }
            columnNames.add(column);
        }
    }

    public boolean escapeText() {
        return false;
    }

    public boolean useEscapeClauseForLike() {
        return true;
    }
}

