/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.DefaultValidator;
import org.apache.fulcrum.intake.validator.InvalidMaskException;
import org.apache.fulcrum.intake.validator.ValidationException;

public class StringValidator
extends DefaultValidator {
    protected String maskString = null;
    protected Pattern maskPattern = null;
    protected String maskMessage = null;

    public StringValidator(Map paramMap) throws InvalidMaskException {
        this.init(paramMap);
    }

    public StringValidator() {
    }

    public void init(Map paramMap) throws InvalidMaskException {
        super.init(paramMap);
        Constraint constraint = (Constraint)paramMap.get("mask");
        if (constraint != null) {
            String param = constraint.getValue();
            this.setMask(param);
            this.maskMessage = constraint.getMessage();
        }
    }

    public void assertValidity(String testValue) throws ValidationException {
        super.assertValidity(testValue);
        if ((this.required || StringUtils.isNotEmpty((String)testValue)) && this.maskPattern != null) {
            boolean patternMatch = this.maskPattern.matcher(testValue).matches();
            this.log.debug((Object)("Trying to match " + testValue + " to pattern " + this.maskString));
            if (!patternMatch) {
                this.errorMessage = this.maskMessage;
                throw new ValidationException(this.maskMessage);
            }
        }
    }

    public String getMask() {
        return this.maskString;
    }

    public void setMask(String mask) throws InvalidMaskException {
        this.maskString = mask;
        int maskOptions = 0;
        try {
            this.log.debug((Object)("Compiling pattern " + this.maskString));
            this.maskPattern = Pattern.compile(this.maskString, maskOptions);
        }
        catch (PatternSyntaxException pe) {
            throw new InvalidMaskException("Could not compile pattern " + this.maskString, pe);
        }
    }

    public String getMaskMessage() {
        return this.maskMessage;
    }

    public void setMaskMessage(String message) {
        this.maskMessage = message;
    }
}

