/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.io.Serializable;
import java.sql.Connection;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.turbine.om.security.SecurityEntity;
import org.apache.turbine.util.security.TurbineSecurityException;

public abstract class TorqueObject
implements SecurityEntity,
Comparable,
Persistent,
Serializable {
    static final long serialVersionUID = 5619862273774652856L;
    protected Persistent obj = null;

    public TorqueObject() {
    }

    public TorqueObject(String name) {
        this.setName(name);
    }

    public TorqueObject(Persistent obj) {
        this.obj = obj;
    }

    public abstract Persistent getPersistentObj();

    @Override
    public abstract String getName();

    @Override
    public abstract void setName(String var1);

    public ObjectKey getPrimaryKey() {
        Persistent p = this.getPersistentObj();
        if (p != null) {
            return p.getPrimaryKey();
        }
        return null;
    }

    public void setPrimaryKey(ObjectKey primaryKey) throws Exception {
        this.getPersistentObj().setPrimaryKey(primaryKey);
    }

    public void setPrimaryKey(String primaryKey) throws Exception {
        this.getPersistentObj().setPrimaryKey(primaryKey);
    }

    public boolean isModified() {
        return this.getPersistentObj().isModified();
    }

    public boolean isNew() {
        return this.getPersistentObj().isNew();
    }

    public void setNew(boolean b) {
        this.getPersistentObj().setNew(b);
    }

    public void setModified(boolean m) {
        this.getPersistentObj().setModified(m);
    }

    public void save(String torqueName) throws Exception {
        this.getPersistentObj().save(torqueName);
    }

    public void save(Connection con) throws Exception {
        this.getPersistentObj().save(con);
    }

    public abstract void save() throws TurbineSecurityException;

    public int compareTo(Object obj) {
        if (this.getClass() != obj.getClass()) {
            throw new ClassCastException();
        }
        String name1 = ((SecurityEntity)obj).getName();
        String name2 = this.getName();
        return name2.compareTo(name1);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TorqueObject) {
            return this.equals((TorqueObject)obj);
        }
        return false;
    }

    public boolean equals(TorqueObject torqueObject) {
        if (torqueObject == null) {
            return false;
        }
        if (this == torqueObject) {
            return true;
        }
        if (this.getPrimaryKey() == null || torqueObject.getPrimaryKey() == null) {
            return false;
        }
        return this.getPrimaryKey().equals(torqueObject.getPrimaryKey());
    }

    public int hashCode() {
        ObjectKey ok = this.getPrimaryKey();
        if (ok == null) {
            return super.hashCode();
        }
        return ok.hashCode();
    }
}

