/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.UserManager;
import org.apache.turbine.services.security.torque.UserPeerManager;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.turbine.util.security.PasswordMismatchException;
import org.apache.turbine.util.security.UnknownEntityException;

public class TorqueUserManager
implements UserManager {
    @Override
    public void init(Configuration conf) throws InitializationException {
        UserPeerManager.init(conf);
    }

    @Override
    public boolean accountExists(User user) throws DataBackendException {
        return this.accountExists(user.getName());
    }

    @Override
    public boolean accountExists(String userName) throws DataBackendException {
        List users;
        Criteria criteria = new Criteria();
        criteria.add(UserPeerManager.getNameColumn(), (Object)userName);
        try {
            users = UserPeerManager.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to check account's presence", e);
        }
        if (users.size() > 1) {
            throw new DataBackendException("Multiple Users with same username '" + userName + "'");
        }
        return users.size() == 1;
    }

    @Override
    public User retrieve(String userName) throws UnknownEntityException, DataBackendException {
        Criteria criteria = new Criteria();
        criteria.add(UserPeerManager.getNameColumn(), (Object)userName);
        List users = this.retrieveList(criteria);
        if (users.size() > 1) {
            throw new DataBackendException("Multiple Users with same username '" + userName + "'");
        }
        if (users.size() == 1) {
            return (User)users.get(0);
        }
        throw new UnknownEntityException("Unknown user '" + userName + "'");
    }

    public User retrieveById(Object key) throws UnknownEntityException, DataBackendException {
        Criteria criteria = new Criteria();
        criteria.add(UserPeerManager.getIdColumn(), key);
        List users = this.retrieveList(criteria);
        if (users.size() > 1) {
            throw new DataBackendException("Multiple Users with same unique Key '" + String.valueOf(key) + "'");
        }
        if (users.size() == 1) {
            return (User)users.get(0);
        }
        throw new UnknownEntityException("Unknown user with key '" + String.valueOf(key) + "'");
    }

    @Override
    public User[] retrieve(Object criteria) throws DataBackendException {
        return this.retrieveList(criteria).toArray(new User[0]);
    }

    @Override
    public List retrieveList(Object criteria) throws DataBackendException {
        if (criteria instanceof Criteria) {
            Criteria c = (Criteria)criteria;
            for (String key : c.keySet()) {
                Criteria.Criterion[] criterion = c.getCriterion(key).getAttachedCriterion();
                for (int i = 0; i < criterion.length; ++i) {
                    if (!StringUtils.isEmpty((String)criterion[i].getTable())) continue;
                    criterion[i].setTable(UserPeerManager.getTableName());
                }
            }
            List users = null;
            try {
                users = UserPeerManager.doSelect(c);
            }
            catch (Exception e) {
                throw new DataBackendException("Failed to retrieve users", e);
            }
            return users;
        }
        throw new DataBackendException("Failed to retrieve users with invalid criteria");
    }

    @Override
    public User retrieve(String userName, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        User user = this.retrieve(userName);
        this.authenticate(user, password);
        return user;
    }

    @Override
    public void store(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        try {
            ((Persistent)user).setNew(false);
            ((Persistent)user).setModified(true);
            ((Persistent)user).save();
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to save user object", e);
        }
    }

    @Override
    public void saveOnSessionUnbind(User user) throws UnknownEntityException, DataBackendException {
        if (!user.hasLoggedIn()) {
            return;
        }
        this.store(user);
    }

    @Override
    public void authenticate(User user, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        if (!TurbineSecurity.checkPassword(password, user.getPassword())) {
            throw new PasswordMismatchException("The passwords do not match");
        }
    }

    @Override
    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        if (!TurbineSecurity.checkPassword(oldPassword, user.getPassword())) {
            throw new PasswordMismatchException("The supplied old password for '" + user.getName() + "' was incorrect");
        }
        user.setPassword(TurbineSecurity.encryptPassword(newPassword));
        this.store(user);
    }

    @Override
    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        user.setPassword(TurbineSecurity.encryptPassword(password));
        this.store(user);
    }

    @Override
    public void createAccount(User user, String initialPassword) throws EntityExistsException, DataBackendException {
        if (StringUtils.isEmpty((String)user.getName())) {
            throw new DataBackendException("Could not create an user with empty name!");
        }
        if (this.accountExists(user)) {
            throw new EntityExistsException("The account '" + user.getName() + "' already exists");
        }
        user.setPassword(TurbineSecurity.encryptPassword(initialPassword));
        try {
            ((Persistent)user).setNew(true);
            ((Persistent)user).setModified(true);
            ((Persistent)user).save();
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to create account '" + user.getName() + "'", e);
        }
    }

    @Override
    public void removeAccount(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        Criteria criteria = new Criteria();
        criteria.add(UserPeerManager.getNameColumn(), (Object)user.getName());
        try {
            UserPeerManager.doDelete(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to remove account '" + user.getName() + "'", e);
        }
    }
}

