/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.FulcrumSecurityException;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Action;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.util.RunData;

public class LoginUser
extends Action {
    public static final String CGI_USERNAME = "username";
    public static final String CGI_PASSWORD = "password";
    private static Log log = LogFactory.getLog(LoginUser.class);
    @TurbineService
    private SecurityService security;
    @TurbineConfiguration
    private Configuration conf;

    @Override
    public void doPerform(PipelineData pipelineData) throws FulcrumSecurityException {
        RunData data = this.getRunData(pipelineData);
        String username = data.getParameters().getString(CGI_USERNAME, "");
        String password = data.getParameters().getString(CGI_PASSWORD, "");
        if (StringUtils.isEmpty((String)username)) {
            return;
        }
        try {
            Object user = this.security.getAuthenticatedUser(username, password);
            data.setUser(user);
            user.setHasLoggedIn(Boolean.TRUE);
            user.updateLastLogin();
            data.save();
        }
        catch (Exception e) {
            if (e instanceof DataBackendException) {
                log.error((Object)e);
            }
            data.setMessage(this.conf.getString("login.error", ""));
            Object anonymousUser = this.security.getAnonymousUser();
            data.setUser(anonymousUser);
            String loginTemplate = this.conf.getString("template.login");
            if (StringUtils.isNotEmpty((String)loginTemplate)) {
                data.setScreenTemplate(loginTemplate);
            }
            data.setScreen(this.conf.getString("screen.login"));
        }
    }
}

