/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.impl;

import java.io.PrintWriter;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleListener;
import org.apache.excalibur.instrument.manager.InstrumentSampleSnapshot;
import org.apache.excalibur.instrument.manager.InstrumentSampleUtils;
import org.apache.excalibur.instrument.manager.impl.DefaultInstrumentManagerImpl;
import org.apache.excalibur.instrument.manager.impl.InstrumentProxy;
import org.apache.excalibur.instrument.manager.impl.InstrumentSample;
import org.apache.excalibur.instrument.manager.impl.InstrumentSampleDescriptorImpl;
import org.apache.excalibur.instrument.manager.impl.XMLUtil;

abstract class AbstractInstrumentSample
extends AbstractLogEnabled
implements InstrumentSample {
    private static long m_zoneOffset;
    private InstrumentProxy m_instrumentProxy;
    private boolean m_configured;
    private String m_name;
    private long m_interval;
    private int m_size;
    private String m_description;
    private InstrumentSampleDescriptor m_descriptor;
    private long m_maxAge;
    protected long m_time;
    private long m_leaseExpirationTime;
    private boolean m_expired;
    private int m_historyIndex;
    private int[] m_historyOld;
    private int[] m_historyNew;
    private InstrumentSampleListener[] m_listeners;
    private int m_stateVersion;

    protected AbstractInstrumentSample(InstrumentProxy instrumentProxy, String name, long interval, int size, String description, long lease) {
        this.m_instrumentProxy = instrumentProxy;
        if (interval < 1L) {
            throw new IllegalArgumentException("interval must be at least 1.");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size must be at least 1.");
        }
        this.m_name = name;
        this.m_interval = interval;
        this.m_size = size;
        this.m_description = description;
        this.m_leaseExpirationTime = lease > 0L ? System.currentTimeMillis() + lease : 0L;
        this.m_maxAge = (long)this.m_size * this.m_interval;
        this.init(0);
        this.m_descriptor = new InstrumentSampleDescriptorImpl(this);
    }

    public InstrumentProxy getInstrumentProxy() {
        return this.m_instrumentProxy;
    }

    public boolean isConfigured() {
        return this.m_configured;
    }

    public final String getName() {
        return this.m_name;
    }

    public final long getInterval() {
        return this.m_interval;
    }

    public final int getSize() {
        return this.m_size;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public InstrumentSampleDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getValue() {
        long time;
        int value;
        boolean update;
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            long now = System.currentTimeMillis();
            update = this.update(now, false);
            value = this.getValueInner();
            time = this.m_time;
        }
        if (update) {
            this.updateListeners(value, time);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTime() {
        long time;
        int value;
        boolean update;
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            long now = System.currentTimeMillis();
            update = this.update(now, false);
            value = this.getValueInner();
            time = this.m_time;
        }
        if (update) {
            this.updateListeners(value, time);
        }
        return time;
    }

    public long getLeaseExpirationTime() {
        return this.m_leaseExpirationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long extendLease(long lease) {
        DefaultInstrumentManagerImpl manager = this.m_instrumentProxy.getInstrumentableProxy().getInstrumentManager();
        lease = Math.max(1L, Math.min(lease, manager.getMaxLeasedSampleLease()));
        manager.incrementLeaseRequests();
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            long newLeaseExpirationTime;
            if (this.m_leaseExpirationTime > 0L && !this.m_expired && (newLeaseExpirationTime = System.currentTimeMillis() + lease) > this.m_leaseExpirationTime) {
                this.m_leaseExpirationTime = newLeaseExpirationTime;
                this.stateChanged();
            }
            return this.m_leaseExpirationTime;
        }
    }

    public void expire() {
        this.update(this.m_leaseExpirationTime, false);
        this.m_expired = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InstrumentSampleSnapshot getSnapshot() {
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            long time = System.currentTimeMillis();
            this.update(time, false);
            return new InstrumentSampleSnapshot(this.m_name, this.m_interval, this.m_size, this.m_time, this.getHistorySnapshot(), this.m_stateVersion);
        }
    }

    public int getStateVersion() {
        return this.m_stateVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstrumentSampleListener(InstrumentSampleListener listener) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("An InstrumentSampleListener was added to sample, " + this.m_name + " : " + listener.getClass().getName());
        }
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            InstrumentSampleListener[] newListeners;
            InstrumentSampleListener[] oldListeners = this.m_listeners;
            if (oldListeners == null) {
                newListeners = new InstrumentSampleListener[]{listener};
            } else {
                newListeners = new InstrumentSampleListener[oldListeners.length + 1];
                System.arraycopy(oldListeners, 0, newListeners, 0, oldListeners.length);
                newListeners[oldListeners.length] = listener;
            }
            this.m_listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstrumentSampleListener(InstrumentSampleListener listener) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("An InstrumentSampleListener was removed from sample, " + this.m_name + " : " + listener.getClass().getName());
        }
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            InstrumentSampleListener[] newListeners;
            InstrumentSampleListener[] oldListeners = this.m_listeners;
            if (oldListeners == null) {
                newListeners = null;
            } else if (oldListeners.length == 1) {
                newListeners = oldListeners[0] == listener ? null : oldListeners;
            } else {
                int pos = -1;
                for (int i = 0; i < oldListeners.length; ++i) {
                    if (oldListeners[i] != listener) continue;
                    pos = i;
                    break;
                }
                if (pos < 0) {
                    newListeners = oldListeners;
                } else {
                    newListeners = new InstrumentSampleListener[oldListeners.length - 1];
                    if (pos > 0) {
                        System.arraycopy(oldListeners, 0, newListeners, 0, pos);
                    }
                    if (pos < oldListeners.length - 1) {
                        System.arraycopy(oldListeners, pos + 1, newListeners, pos, oldListeners.length - 1 - pos);
                    }
                }
            }
            this.m_listeners = newListeners;
        }
    }

    protected void updateListeners(int value, long time) {
        InstrumentSampleListener[] listeners = this.m_listeners;
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].setValue(this.getName(), value, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState(PrintWriter out) {
        long time;
        int value;
        boolean update;
        if (!this.isConfigured() && this.getLeaseExpirationTime() <= 0L) {
            return;
        }
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            long now = System.currentTimeMillis();
            update = this.update(now, false);
            value = this.getValueInner();
            time = this.m_time;
            String history = this.getHistoryList();
            if (this.getLeaseExpirationTime() != 0L || history != null) {
                out.print("<sample name=\"");
                out.print(XMLUtil.getXMLSafeString(this.m_name));
                out.print("\" type=\"");
                out.print(InstrumentSampleUtils.getInstrumentSampleTypeName((int)this.getType()));
                out.print("\" interval=\"");
                out.print(this.m_interval);
                out.print("\" size=\"");
                out.print(this.m_size);
                out.print("\" time=\"");
                out.print(this.m_time);
                out.print("\"");
                if (this.getLeaseExpirationTime() != 0L) {
                    out.print(" lease-expiration=\"");
                    out.print(this.getLeaseExpirationTime());
                    out.print("\"");
                    out.print(" description=\"");
                    out.print(XMLUtil.getXMLSafeString(this.m_description));
                    out.print("\"");
                }
                this.writeStateAttributes(out);
                if (history == null) {
                    out.println("/>");
                } else {
                    out.println(">");
                    out.print("<history>");
                    out.print(history);
                    out.println("</history>");
                    out.println("</sample>");
                }
            }
        }
        if (update) {
            this.updateListeners(value, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadState(Configuration state) throws ConfigurationException {
        long sampleTime;
        int sampleValue;
        boolean update;
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            int[] sampleValues;
            long savedTime = this.m_time = state.getAttributeAsLong("time");
            long leaseExpirationTime = state.getAttributeAsLong("lease-expiration", 0L);
            if (this.m_leaseExpirationTime != 0L && leaseExpirationTime > this.m_leaseExpirationTime) {
                this.m_leaseExpirationTime = leaseExpirationTime;
            }
            this.m_historyIndex = 0;
            Configuration history = state.getChild("history", false);
            if (history == null) {
                sampleValues = new int[]{};
            } else {
                String compactSamples = history.getValue();
                StringTokenizer st = new StringTokenizer(compactSamples, ",");
                sampleValues = new int[st.countTokens()];
                for (int i = 0; i < sampleValues.length; ++i) {
                    String token = st.nextToken();
                    try {
                        sampleValues[i] = Integer.parseInt(token);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ConfigurationException("The compact sample data could not be loaded, because of a number format problem '" + token + "', " + "for InstrumentSample: " + this.m_name, history);
                    }
                }
            }
            int value = sampleValues.length > 0 ? sampleValues[0] : 0;
            for (int i = 0; i < this.m_size - 1; ++i) {
                this.m_historyOld[this.m_size - 2 - i] = i < sampleValues.length - 1 ? sampleValues[i + 1] : 0;
            }
            this.loadState(value, state);
            long now = System.currentTimeMillis();
            update = this.update(now, true);
            sampleValue = this.getValueInner();
            sampleTime = this.m_time;
            if (this.m_leaseExpirationTime > 0L) {
                this.getInstrumentProxy().getInstrumentableProxy().getInstrumentManager().registerLeasedInstrumentSample(this);
            }
        }
        this.stateChanged();
        if (update) {
            this.updateListeners(sampleValue, sampleTime);
        }
    }

    void setConfigured() {
        this.m_configured = true;
    }

    private void init(int fillValue) {
        this.m_time = this.calculateSampleTime(System.currentTimeMillis());
        this.m_historyIndex = 0;
        if (this.m_historyOld == null) {
            this.m_historyOld = new int[this.m_size - 1];
            this.m_historyNew = new int[this.m_size - 1];
        }
        for (int i = 0; i < this.m_historyOld.length; ++i) {
            this.m_historyOld[i] = fillValue;
            this.m_historyNew[i] = fillValue;
        }
    }

    protected void writeStateAttributes(PrintWriter out) {
    }

    protected abstract void loadState(int var1, Configuration var2) throws ConfigurationException;

    private long calculateSampleTime(long time) {
        long offset = (time + m_zoneOffset) % this.m_interval;
        return time - offset;
    }

    protected abstract int getValueInner();

    protected abstract void advanceToNextSample(boolean var1);

    protected abstract int getFillValue();

    protected boolean update(long time, boolean reset) {
        if (this.m_expired) {
            return false;
        }
        if (time - this.m_time >= this.m_interval) {
            if (time - this.m_time >= this.m_maxAge) {
                this.advanceToNextSample(reset);
                this.init(this.getFillValue());
            } else {
                while (time - this.m_time >= this.m_interval) {
                    this.m_historyNew[this.m_historyIndex] = this.getValueInner();
                    this.m_time += this.m_interval;
                    this.advanceToNextSample(reset);
                    ++this.m_historyIndex;
                    if (this.m_historyIndex < this.m_size - 1) continue;
                    int[] tmp = this.m_historyOld;
                    this.m_historyOld = this.m_historyNew;
                    this.m_historyNew = tmp;
                    this.m_historyIndex = 0;
                }
            }
            return true;
        }
        return false;
    }

    private int[] getHistorySnapshot() {
        int[] history = new int[this.m_size];
        int sizem1 = this.m_size - 1;
        if (this.m_size > 1) {
            if (this.m_historyIndex < sizem1) {
                System.arraycopy(this.m_historyOld, this.m_historyIndex, history, 0, sizem1 - this.m_historyIndex);
            }
            if (this.m_historyIndex > 0) {
                System.arraycopy(this.m_historyNew, 0, history, sizem1 - this.m_historyIndex, this.m_historyIndex);
            }
        }
        history[this.m_size - 1] = this.getValueInner();
        return history;
    }

    private String getHistoryList() {
        int[] history = this.getHistorySnapshot();
        boolean found = false;
        for (int i = history.length - 1; i >= 0; --i) {
            if (history[i] == 0) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(history[history.length - 1]);
        for (int i = history.length - 2; i >= 0; --i) {
            sb.append(',');
            sb.append(history[i]);
        }
        return sb.toString();
    }

    protected void stateChanged() {
        ++this.m_stateVersion;
        this.m_instrumentProxy.stateChanged();
    }

    void makePermanent() {
        this.m_leaseExpirationTime = 0L;
    }

    public String toString() {
        return "InstrumentSample[name=" + this.m_name + ", type=" + InstrumentSampleUtils.getInstrumentSampleTypeName((int)this.getType()) + ", interval=" + this.m_interval + ", size=" + this.m_size + ", lease=" + this.m_leaseExpirationTime + "]";
    }

    static {
        Calendar now = Calendar.getInstance();
        m_zoneOffset = now.get(15);
    }
}

