/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.datastore;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.datastore.RefreshableDataStore;
import net.sf.uadetector.datastore.UpdateOperation;
import net.sf.uadetector.internal.util.ExecutorServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUpdateOperation
implements UpdateOperation {
    private static final String EMPTY_VERSION = "";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUpdateOperation.class);
    private static final String MSG_NO_UPDATE_AVAILABLE = "No update available. Current version is '%s'.";
    private static final String MSG_NO_UPDATE_CHECK_POSSIBLE = "Can not check for an updated version. Are you sure you have an established internet connection?";
    private static final String MSG_NO_UPDATE_CHECK_POSSIBLE__DEBUG = "Can not check for an updated version: %s: %s";
    private static final String MSG_UPDATE_AVAILABLE = "An update is available. Current version is '%s' and remote version is '%s'.";
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\d{8}\\-\\d{2}");
    private final ExecutorService executorService = ExecutorServices.createBackgroundExecutor();
    private long lastUpdateCheck = 0L;
    private final RefreshableDataStore store;

    static boolean hasUpdate(String newer, String older) {
        return VERSION_PATTERN.matcher(newer).matches() && VERSION_PATTERN.matcher(older).matches() ? newer.compareTo(older) > 0 : false;
    }

    @Nullable
    private static String retrieveRemoteVersion(@Nonnull URL url, @Nonnull Charset charset) throws IOException {
        InputStream stream = url.openStream();
        InputStreamReader reader = new InputStreamReader(stream, charset);
        LineNumberReader lnr = new LineNumberReader(reader);
        String line = lnr.readLine();
        lnr.close();
        reader.close();
        stream.close();
        return line;
    }

    public AbstractUpdateOperation(@Nonnull RefreshableDataStore dataStore) {
        Check.notNull((Object)dataStore, (String)"dataStore");
        this.store = dataStore;
    }

    @Nonnull
    private String getCurrentVersion() {
        return this.store.getData().getVersion();
    }

    @Override
    public long getLastUpdateCheck() {
        return this.lastUpdateCheck;
    }

    protected boolean isUpdateAvailable() {
        boolean result = false;
        String version = EMPTY_VERSION;
        try {
            version = AbstractUpdateOperation.retrieveRemoteVersion(this.store.getVersionUrl(), this.store.getCharset());
        }
        catch (IOException e) {
            LOG.info(MSG_NO_UPDATE_CHECK_POSSIBLE);
            LOG.debug(String.format(MSG_NO_UPDATE_CHECK_POSSIBLE__DEBUG, e.getClass().getName(), e.getLocalizedMessage()));
        }
        if (AbstractUpdateOperation.hasUpdate(version, this.getCurrentVersion())) {
            LOG.debug(String.format(MSG_UPDATE_AVAILABLE, this.getCurrentVersion(), version));
            result = true;
        } else {
            LOG.debug(String.format(MSG_NO_UPDATE_AVAILABLE, this.getCurrentVersion()));
        }
        this.lastUpdateCheck = System.currentTimeMillis();
        return result;
    }

    @Override
    public void run() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                AbstractUpdateOperation.this.call();
            }
        });
    }

    @Override
    public void shutdown() {
        ExecutorServices.shutdown(this.executorService);
    }
}

