/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.util.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorServices {
    private static final Set<ExecutorService> BACKGROUND_EXECUTORS = Collections.synchronizedSet(new HashSet(3));
    private static final String DEFAULT_BACKGROUND_EXECUTOR_NAME = "update-operation";
    private static final String DEFAULT_SCHEDULER_NAME = "update-scheduler";
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorServices.class);
    private static final Set<ScheduledExecutorService> SCHEDULERS = Collections.synchronizedSet(new HashSet(3));
    public static final long SHUTDOWN_DURATION = 5L;

    public static ExecutorService createBackgroundExecutor() {
        ExecutorService executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory(DEFAULT_BACKGROUND_EXECUTOR_NAME));
        BACKGROUND_EXECUTORS.add(executor);
        return executor;
    }

    public static ScheduledExecutorService createScheduler() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory(DEFAULT_SCHEDULER_NAME));
        SCHEDULERS.add(scheduler);
        return scheduler;
    }

    public static void shutdown(@Nonnull ExecutorService executorService) {
        Check.notNull((Object)executorService, (String)"executorService");
        ExecutorServices.shutdown(executorService, 5L, TimeUnit.SECONDS);
    }

    public static void shutdown(@Nonnull ExecutorService executorService, @Nonnegative long duration, @Nonnull TimeUnit unit) {
        Check.notNull((Object)executorService, (String)"executorService");
        Check.notNull((Object)duration, (String)"duration");
        Check.notNull((Object)((Object)unit), (String)"unit");
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(duration, unit)) {
                LOG.info(String.format("Executor did not terminate in %s %s.", duration, unit.name().toLowerCase()));
                List<Runnable> droppedTasks = executorService.shutdownNow();
                LOG.info("Executor was abruptly shut down. " + droppedTasks.size() + " tasks will not be executed.");
            }
            ExecutorServices.unregisterIfPossible(executorService);
        }
        catch (InterruptedException e) {
            LOG.warn("Executor termination failed: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void shutdownAll() {
        for (ExecutorService executor : new ArrayList<ExecutorService>(BACKGROUND_EXECUTORS)) {
            ExecutorServices.shutdown(executor);
            BACKGROUND_EXECUTORS.remove(executor);
        }
        for (ScheduledExecutorService scheduler : new ArrayList<ScheduledExecutorService>(SCHEDULERS)) {
            ExecutorServices.shutdown(scheduler);
            SCHEDULERS.remove(scheduler);
        }
    }

    private static void unregisterIfPossible(ExecutorService executorService) {
        if (executorService instanceof ScheduledExecutorService) {
            SCHEDULERS.remove(executorService);
        } else {
            BACKGROUND_EXECUTORS.remove(executorService);
        }
    }

    private ExecutorServices() {
    }
}

