/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsp;

import java.io.File;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.services.pull.tools.TemplateLink;
import org.apache.turbine.services.template.BaseTemplateEngineService;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class TurbineJspService
extends BaseTemplateEngineService
implements JspService {
    private String[] templatePaths;
    private String[] relativeTemplatePaths;
    private int bufferSize;
    private static Logger log = LogManager.getLogger(TurbineJspService.class);

    @Override
    public void init() throws InitializationException {
        try {
            this.initJsp();
            this.registerConfiguration("jsp");
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("TurbineJspService failed to initialize", e);
        }
    }

    @Override
    public void addDefaultObjects(PipelineData pipelineData) {
        HttpServletRequest req = pipelineData.get(Turbine.class, HttpServletRequest.class);
        TemplateLink templateLink = new TemplateLink();
        templateLink.init(pipelineData);
        req.setAttribute("link", (Object)templateLink);
        req.setAttribute("pdata", (Object)pipelineData);
    }

    @Override
    public int getDefaultBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void handleRequest(PipelineData pipelineData, String templateName, boolean isForward) throws TurbineException {
        if (!(pipelineData instanceof RunData)) {
            throw new RuntimeException("Can't cast to rundata from pipeline data.");
        }
        RunData data = (RunData)pipelineData;
        String relativeTemplateName = this.getRelativeTemplateName(templateName);
        if (StringUtils.isEmpty((CharSequence)relativeTemplateName)) {
            throw new TurbineException("Template " + templateName + " not found in template paths");
        }
        RequestDispatcher dispatcher = data.getServletContext().getRequestDispatcher(relativeTemplateName);
        try {
            if (isForward) {
                dispatcher.forward((ServletRequest)data.getRequest(), (ServletResponse)data.getResponse());
            } else {
                data.getResponse().getWriter().flush();
                dispatcher.include((ServletRequest)data.getRequest(), (ServletResponse)data.getResponse());
            }
        }
        catch (Exception e) {
            try {
                data.getResponse().getWriter().print("Error encountered processing a template: " + templateName);
                e.printStackTrace(data.getResponse().getWriter());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new TurbineException("Error encountered processing a template: " + templateName, e);
        }
    }

    @Override
    public void handleRequest(PipelineData pipelineData, String templateName) throws TurbineException {
        this.handleRequest(pipelineData, templateName, false);
    }

    private void initJsp() throws Exception {
        Configuration config = this.getConfiguration();
        this.relativeTemplatePaths = config.getStringArray("templates");
        this.templatePaths = new String[this.relativeTemplatePaths.length];
        for (int i = 0; i < this.relativeTemplatePaths.length; ++i) {
            this.relativeTemplatePaths[i] = this.warnAbsolute(this.relativeTemplatePaths[i]);
            this.templatePaths[i] = Turbine.getRealPath(this.relativeTemplatePaths[i]);
        }
        this.bufferSize = config.getInt("buffer.size", 8192);
    }

    @Override
    public boolean templateExists(String template) {
        for (int i = 0; i < this.templatePaths.length; ++i) {
            if (!this.templateExists(this.templatePaths[i], template)) continue;
            return true;
        }
        return false;
    }

    private boolean templateExists(String path, String template) {
        return new File(path, template).exists();
    }

    @Override
    public String getRelativeTemplateName(String template) {
        String relativeTemplate = this.warnAbsolute(template);
        for (int i = 0; i < this.templatePaths.length; ++i) {
            if (!this.templateExists(this.templatePaths[i], relativeTemplate)) continue;
            return this.relativeTemplatePaths[i] + "/" + relativeTemplate;
        }
        return null;
    }

    private String warnAbsolute(String template) {
        if (template.startsWith("/")) {
            log.warn("Template {} has a leading /, which is wrong!", (Object)template);
            return template.substring(1);
        }
        return template;
    }
}

