/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.template.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TemplateEngineService;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.services.template.mapper.BaseTemplateMapper;
import org.apache.turbine.services.template.mapper.Mapper;

public class LayoutTemplateMapper
extends BaseTemplateMapper
implements Mapper {
    private static final Logger log = LogManager.getLogger(LayoutTemplateMapper.class);

    @Override
    public String doMapping(String template) {
        log.debug("doMapping({})", (Object)template);
        ArrayList<String> components = new ArrayList<String>(Arrays.asList(StringUtils.split((String)template, (String)String.valueOf(','))));
        int componentSize = components.size() - 1;
        String templateName = (String)components.get(componentSize);
        components.remove(componentSize--);
        log.debug("templateName is {}", (Object)templateName);
        TemplateService templateService = (TemplateService)TurbineServices.getInstance().getService("TemplateService");
        TemplateEngineService tes = templateService.getTemplateEngineService(templateName);
        if (tes == null) {
            return null;
        }
        String defaultName = templateService.getDefaultLayoutTemplateName(templateName);
        boolean firstRun = !templateName.equals(defaultName);
        while (true) {
            String templatePackage = StringUtils.join(components.iterator(), (String)String.valueOf(this.separator));
            log.debug("templatePackage is now: {}", (Object)templatePackage);
            StringBuilder testName = new StringBuilder();
            if (!components.isEmpty()) {
                testName.append(templatePackage);
                testName.append(this.separator);
            }
            testName.append(firstRun ? templateName : defaultName);
            StringBuilder templatePath = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
                templatePath.append(this.prefix);
                templatePath.append(this.separator);
            }
            templatePath.append((CharSequence)testName);
            log.debug("Looking for {}", (Object)templatePath);
            if (tes.templateExists(templatePath.toString())) {
                log.debug("Found it, returning {}", (Object)testName);
                return testName.toString();
            }
            if (firstRun) {
                firstRun = false;
                continue;
            }
            if (components.isEmpty()) break;
            components.remove(componentSize--);
        }
        log.debug("Returning default");
        return this.getDefaultName(template);
    }
}

