/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import java.util.List;
import java.util.stream.Collectors;
import nl.basjes.parse.useragent.Analyzer;
import nl.basjes.parse.useragent.PreHeatCases;
import nl.basjes.parse.useragent.config.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface AnalyzerPreHeater
extends Analyzer {
    public static final Logger LOG = LogManager.getFormatterLogger(AnalyzerPreHeater.class);
    public static final long MAX_PRE_HEAT_ITERATIONS = 1000000L;

    public List<TestCase> getPreheatTestCases();

    default public List<TestCase> internalGetTestCasesForPreheat() {
        List<TestCase> result = this.getPreheatTestCases();
        if (result == null || result.isEmpty()) {
            result = PreHeatCases.USERAGENTS.stream().map(ua -> new TestCase((String)ua, "PreHeat fallback")).collect(Collectors.toList());
        }
        return result;
    }

    default public long preHeat() {
        List<TestCase> testCases = this.internalGetTestCasesForPreheat();
        return this.preHeat(testCases, testCases.size(), true);
    }

    default public long preHeat(long preheatIterations) {
        return this.preHeat(preheatIterations, true);
    }

    default public long preHeat(long preheatIterations, boolean log) {
        return this.preHeat(this.internalGetTestCasesForPreheat(), preheatIterations, log);
    }

    default public long preHeat(List<TestCase> testCases, long preheatIterations, boolean log) {
        if (testCases == null || testCases.isEmpty()) {
            LOG.fatal("NO PREHEAT WAS DONE. This should never occur.");
            return 0L;
        }
        if (preheatIterations <= 0L) {
            LOG.warn("NO PREHEAT WAS DONE. Simply because you asked for %d to run.", (Object)preheatIterations);
            return 0L;
        }
        if (preheatIterations > 1000000L) {
            LOG.warn("NO PREHEAT WAS DONE. Simply because you asked for too many (%d > %d) to run.", (Object)preheatIterations, (Object)1000000L);
            return 0L;
        }
        if (log) {
            LOG.info("Preheating JVM by running %d testcases.", (Object)preheatIterations);
        }
        long remainingIterations = preheatIterations;
        long syntaxErrors = 0L;
        long startTime = System.nanoTime();
        block0: while (remainingIterations > 0L) {
            for (TestCase testCase : testCases) {
                --remainingIterations;
                if (this.parse(testCase.getHeaders()).hasSyntaxError()) {
                    ++syntaxErrors;
                }
                if (remainingIterations > 0L) continue;
                continue block0;
            }
        }
        long stopTime = System.nanoTime();
        if (log) {
            LOG.info("Preheating JVM completed. Parsing %d testcases took %d ms (average %6.6f ms)", (Object)preheatIterations, (Object)((stopTime - startTime) / 1000000L), (Object)((double)(stopTime - startTime) / 1000000.0 / (double)preheatIterations));
            LOG.trace("Of those %d had a Syntax Error", (Object)syntaxErrors);
        }
        return preheatIterations;
    }
}

