/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.spi;

import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.spi.AbstractEntityManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractGroupManager
extends AbstractEntityManager
implements GroupManager {
    private static final long serialVersionUID = 1L;

    protected abstract <T extends Group> T persistNewGroup(T var1) throws DataBackendException;

    @Override
    public <T extends Group> T getGroupInstance() throws DataBackendException {
        try {
            Group group = (Group)Class.forName(this.getClassName()).newInstance();
            return (T)group;
        }
        catch (Exception e) {
            throw new DataBackendException("Problem creating instance of class " + this.getClassName(), e);
        }
    }

    @Override
    public <T extends Group> T getGroupInstance(String groupName) throws DataBackendException {
        T group = this.getGroupInstance();
        group.setName(groupName);
        return group;
    }

    @Override
    public <T extends Group> T getGroupByName(String name) throws DataBackendException, UnknownEntityException {
        Group group = (Group)this.getAllGroups().getByName(name);
        if (group == null) {
            throw new UnknownEntityException("The specified group does not exist");
        }
        return (T)group;
    }

    @Override
    public <T extends Group> T getGroupById(Object id) throws DataBackendException, UnknownEntityException {
        Group group = (Group)this.getAllGroups().getById(id);
        if (group == null) {
            throw new UnknownEntityException("The specified group does not exist");
        }
        return (T)group;
    }

    @Override
    public synchronized <T extends Group> T addGroup(T group) throws DataBackendException, EntityExistsException {
        boolean groupExists = false;
        if (StringUtils.isEmpty((CharSequence)group.getName())) {
            throw new DataBackendException("Could not create a group with empty name!");
        }
        groupExists = this.checkExists(group);
        if (!groupExists) {
            return this.persistNewGroup(group);
        }
        throw new EntityExistsException("Group '" + String.valueOf(group) + "' already exists");
    }

    @Override
    public boolean checkExists(Group group) throws DataBackendException {
        return this.checkExists(group.getName());
    }
}

