/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.uima.cas.Type;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.TypeSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogKeyVerifyJavaNames;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.TypesWithNameSpaces;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddTypeDialog
extends AbstractDialogKeyVerifyJavaNames {
    private StyledText typeNameUI;
    private Text supertypeNameUI;
    private Text descriptionUI;
    public String typeName;
    private String originalTypeName;
    public String supertypeName;
    public String description;
    private TypeSection typeSection;
    private TypeDescription existingTd = null;
    private TypesWithNameSpaces allTypesList;

    public AddTypeDialog(AbstractSection aSection) {
        super(aSection, "Add a Type", "Use this panel to specify a type.");
        this.typeSection = (TypeSection)aSection;
    }

    public AddTypeDialog(AbstractSection aSection, TypeDescription aExistingTd) {
        this(aSection);
        this.existingTd = aExistingTd;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent, this.existingTd);
        this.createWideLabel(mainArea, "Type names must be globally unique, unless you are intentionally redefining another type.");
        Composite twoCol = new Composite(mainArea, 0);
        twoCol.setLayout((Layout)new GridLayout(2, false));
        twoCol.setLayoutData((Object)new GridData(1808));
        this.typeNameUI = this.newLabeledSingleLineStyledText(twoCol, "Type Name", "");
        this.typeNameUI.setText("some.typename.you.Choose");
        new Label(twoCol, 0).setText("Supertype:");
        this.supertypeNameUI = this.newTypeInput(this.section, twoCol);
        this.descriptionUI = this.newDescription(twoCol, "");
        this.newErrorMessage(twoCol, 2);
        if (null != this.existingTd) {
            this.descriptionUI.setText(AddTypeDialog.convertNull(this.existingTd.getDescription()));
            this.originalTypeName = this.existingTd.getName();
            this.typeNameUI.setText(this.originalTypeName);
            this.supertypeNameUI.setText(AddTypeDialog.convertNull(this.existingTd.getSupertypeName()));
        } else {
            this.supertypeNameUI.setText("uima.tcas.Annotation");
        }
        return mainArea;
    }

    @Override
    public TypesWithNameSpaces getTypeSystemInfoList() {
        TypesWithNameSpaces result = super.getTypeSystemInfoList();
        boolean hasFeatures = false;
        boolean hasAllowedValues = false;
        if (null != this.existingTd) {
            hasFeatures = null != this.existingTd.getFeatures() && this.existingTd.getFeatures().length > 0;
            boolean bl = hasAllowedValues = null != this.existingTd.getAllowedValues() && this.existingTd.getAllowedValues().length > 0;
            if (hasAllowedValues) {
                result.add("uima.cas.String");
                this.allTypesList = result;
                return result;
            }
        }
        Type[] allTypes = this.editor.allTypes.get().values().toArray(new Type[0]);
        Arrays.sort(allTypes, new Comparator(){

            public int compare(Object o1, Object o2) {
                Type t1 = (Type)o1;
                Type t2 = (Type)o2;
                return t1.getShortName().compareTo(t2.getShortName());
            }
        });
        for (int i = 0; i < allTypes.length; ++i) {
            Type type = allTypes[i];
            if (type.isInheritanceFinal() && !"uima.cas.String".equals(type.getName()) || hasFeatures && "uima.cas.String".equals(type.getName())) continue;
            result.add(type.getName());
        }
        this.allTypesList = result;
        return result;
    }

    @Override
    public void copyValuesFromGUI() {
        this.typeName = this.typeNameUI.getText();
        this.description = AddTypeDialog.nullIf0lengthString(this.descriptionUI.getText());
        this.supertypeName = this.supertypeNameUI.getText();
    }

    @Override
    public boolean isValid() {
        String errMsg;
        if (this.typeName.length() == 0) {
            return false;
        }
        if (this.typeName.charAt(this.typeName.length() - 1) == '.') {
            this.setErrorMessage("Name cannot end with a period (.)");
            return false;
        }
        if (!this.typeName.equals(this.originalTypeName) && null != (errMsg = this.typeSection.checkDuplTypeName(this.typeName))) {
            this.setErrorMessage(errMsg);
            return false;
        }
        if (!this.typeContainedInTypeSystemInfoList(this.supertypeName, this.allTypesList)) {
            this.setErrorMessage("SuperType '" + this.supertypeName + "' is unknown. If this is intended, please define it first.");
            return false;
        }
        TypeDescription importedType = this.editor.getImportedTypeSystemDesription().getType(this.typeName);
        if (null != importedType && !this.supertypeName.equals(importedType.getSupertypeName())) {
            this.setErrorMessage("The supertype specified must be '" + importedType.getSupertypeName() + "' due to merging with imported types.  Please change it to this type.");
            return false;
        }
        return true;
    }

    @Override
    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled(this.typeName.length() > 0);
    }
}

