/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class IsCondition
extends TypeSentiveCondition {
    public IsCondition(ITypeExpression type) {
        super(type);
    }

    public IsCondition(AbstractTypeListExpression list) {
        super(list);
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        if (annotation == null) {
            return new EvaluatedCondition(this, false);
        }
        RutaBasic beginAnchor = stream.getBeginAnchor(annotation.getBegin());
        if (!this.isWorkingOnList()) {
            Collection beginAnchors;
            Type t = this.type.getType(context, stream);
            boolean result = false;
            if (t != null && (beginAnchors = beginAnchor.getBeginAnchors(t)) != null) {
                AnnotationFS annotationFS;
                Iterator iterator = beginAnchors.iterator();
                while (iterator.hasNext() && !(result |= this.check(annotation, annotationFS = (AnnotationFS)iterator.next()))) {
                }
            }
            return new EvaluatedCondition(this, result);
        }
        boolean result = false;
        List types = this.getList().getList(context, stream);
        for (Type type : types) {
            AnnotationFS annotationFS;
            Collection beginAnchors = beginAnchor.getBeginAnchors(type);
            if (beginAnchors == null) continue;
            Iterator iterator = beginAnchors.iterator();
            while (iterator.hasNext() && !(result |= this.check(annotation, annotationFS = (AnnotationFS)iterator.next()))) {
            }
        }
        return new EvaluatedCondition(this, result);
    }

    private boolean check(AnnotationFS a1, AnnotationFS a2) {
        boolean result = false;
        if (a1 != null && a2 != null && a1.getBegin() == a2.getBegin() && a1.getEnd() == a2.getEnd()) {
            result = true;
        }
        return result;
    }
}

