/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.config.hosts.ConfigFileHostEntryResolver;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.common.util.io.IoUtils;

public class DefaultConfigFileHostEntryResolver
extends ConfigFileHostEntryResolver {
    public static final DefaultConfigFileHostEntryResolver INSTANCE = new DefaultConfigFileHostEntryResolver(true);
    private final boolean strict;

    public DefaultConfigFileHostEntryResolver(boolean strict) {
        this(HostConfigEntry.getDefaultHostConfigFile(), strict, new LinkOption[0]);
    }

    public DefaultConfigFileHostEntryResolver(File file, boolean strict) {
        this(Objects.requireNonNull(file, "No file provided").toPath(), strict, IoUtils.getLinkOptions(true));
    }

    public DefaultConfigFileHostEntryResolver(Path path, boolean strict, LinkOption ... options) {
        super(path, options);
        this.strict = strict;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected List<HostConfigEntry> reloadHostConfigEntries(Path path, String host, int port, String username) throws IOException {
        if (this.isStrict()) {
            AbstractMap.SimpleImmutableEntry<String, Object> violation;
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadHostConfigEntries({}@{}:{}) check permissions of {}", new Object[]{username, host, port, path});
            }
            if ((violation = DefaultConfigFileHostEntryResolver.validateStrictConfigFilePermissions(path, new LinkOption[0])) != null) {
                this.log.warn("reloadHostConfigEntries({}@{}:{}) invalid file={} permissions: {}", new Object[]{username, host, port, path, violation.getKey()});
                this.updateReloadAttributes();
                return Collections.emptyList();
            }
        }
        return super.reloadHostConfigEntries(path, host, port, username);
    }
}

