/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.processor;

import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.segments.SegmentsAndScores;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.router.api.ProfileToImport;
import org.apache.unomi.router.api.services.ProfileImportService;

public class UnomiStorageProcessor
implements Processor {
    private ProfileImportService profileImportService;
    private SegmentService segmentService;

    public void process(Exchange exchange) throws Exception {
        if (exchange.getIn() != null) {
            Message message = exchange.getIn();
            ProfileToImport profileToImport = (ProfileToImport)message.getBody();
            if (!profileToImport.isProfileToDelete()) {
                Map scores;
                SegmentsAndScores segmentsAndScoringForProfile = this.segmentService.getSegmentsAndScoresForProfile((Profile)profileToImport);
                Set segments = segmentsAndScoringForProfile.getSegments();
                if (!segments.equals(profileToImport.getSegments())) {
                    profileToImport.setSegments(segments);
                }
                if (!(scores = segmentsAndScoringForProfile.getScores()).equals(profileToImport.getScores())) {
                    profileToImport.setScores(scores);
                }
            }
            this.profileImportService.saveMergeDeleteImportedProfile(profileToImport);
        }
    }

    public void setProfileImportService(ProfileImportService profileImportService) {
        this.profileImportService = profileImportService;
    }

    public void setSegmentService(SegmentService segmentService) {
        this.segmentService = segmentService;
    }
}

