/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.Session;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.JsrSessionListener;

public class JsrSessionTracker
extends AbstractLifeCycle
implements JsrSessionListener {
    private CopyOnWriteArraySet<JsrSession> sessions = new CopyOnWriteArraySet();

    public Set<Session> getSessions() {
        return Collections.unmodifiableSet(this.sessions);
    }

    @Override
    public void onSessionOpened(JsrSession session) {
        this.sessions.add(session);
    }

    @Override
    public void onSessionClosed(JsrSession session) {
        this.sessions.remove(session);
    }

    protected void doStop() throws Exception {
        for (JsrSession session : this.sessions) {
            LifeCycle.stop((Object)session);
        }
        super.doStop();
    }
}

