/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.nls;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageUtil {
    private final ResourceBundle messages;
    private static final StackFinder finder = AccessController.doPrivileged(new PrivilegedAction<StackFinder>(){

        @Override
        public StackFinder run() {
            return new StackFinder();
        }
    });

    private MessageUtil(ResourceBundle b) {
        this.messages = b;
    }

    public String getMessage(String key, Object ... inserts) {
        String message;
        try {
            message = this.messages.getString(key);
            if (inserts != null && inserts.length > 0) {
                message = MessageFormat.format(message, inserts);
            }
        }
        catch (MissingResourceException e) {
            message = key;
        }
        return message;
    }

    public static MessageUtil createMessageUtil(Class<?> context, String baseName) {
        return MessageUtil.createMessageUtil(FrameworkUtil.getBundle(context), baseName);
    }

    public static MessageUtil createMessageUtil(String baseName) {
        Class<?>[] stack;
        for (Class<?> clazz : stack = finder.getClassContext()) {
            if (clazz == MessageUtil.class) continue;
            return MessageUtil.createMessageUtil(clazz, baseName);
        }
        throw new MissingResourceException(org.apache.aries.util.internal.MessageUtil.getMessage((String)"UTIL0014E", (Object[])new Object[]{baseName}), baseName, null);
    }

    public static MessageUtil createMessageUtil(final Bundle b, String baseName) {
        ResourceBundle rb;
        if (b == null) {
            rb = ResourceBundle.getBundle(baseName);
        } else {
            ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return AriesFrameworkUtil.getClassLoader((Bundle)b);
                }
            });
            rb = ResourceBundle.getBundle(baseName, Locale.getDefault(), loader);
        }
        return new MessageUtil(rb);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StackFinder
    extends SecurityManager {
        private StackFinder() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

