/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.YamlClientFailoverConfigBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.Preconditions;
import java.io.InputStream;
import java.util.Properties;

public class ClientFailoverClasspathYamlConfig
extends ClientFailoverConfig {
    private static final ILogger LOGGER = Logger.getLogger(ClientFailoverClasspathYamlConfig.class);

    public ClientFailoverClasspathYamlConfig(String resource) {
        this(resource, System.getProperties());
    }

    public ClientFailoverClasspathYamlConfig(String resource, Properties properties) {
        this(Thread.currentThread().getContextClassLoader(), resource, properties);
    }

    public ClientFailoverClasspathYamlConfig(ClassLoader classLoader, String resource, Properties properties) {
        Preconditions.checkTrue(classLoader != null, "classLoader can't be null");
        Preconditions.checkTrue(resource != null, "resource can't be null");
        Preconditions.checkTrue(properties != null, "properties can't be null");
        LOGGER.info("Configuring Hazelcast Client Failover from '" + resource + "'.");
        InputStream in = classLoader.getResourceAsStream(resource);
        Preconditions.checkTrue(in != null, "Specified resource '" + resource + "' could not be found!");
        YamlClientFailoverConfigBuilder configBuilder = new YamlClientFailoverConfigBuilder(in);
        configBuilder.setProperties(properties);
        configBuilder.build(this);
    }
}

