/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.control;

import java.util.Map;
import java.util.Set;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.command.CommandHandler;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.ManageGroupAction;
import org.apache.karaf.cellar.core.control.ManageGroupCommand;
import org.apache.karaf.cellar.core.control.ManageGroupResult;
import org.apache.karaf.cellar.core.control.Switch;

public class ManageGroupCommandHandler
extends CommandHandler<ManageGroupCommand, ManageGroupResult> {
    public static final String SWITCH_ID = "org.apache.karaf.cellar.command.managegroup.switch";
    private final Switch commandSwitch = new BasicSwitch("org.apache.karaf.cellar.command.managegroup.switch");

    @Override
    public ManageGroupResult execute(ManageGroupCommand command) {
        ManageGroupResult result = new ManageGroupResult(command.getId());
        ManageGroupAction action = command.getAction();
        String targetGroupName = command.getGroupName();
        if (ManageGroupAction.JOIN.equals((Object)action)) {
            this.joinGroup(targetGroupName);
        } else if (ManageGroupAction.QUIT.equals((Object)action)) {
            this.quitGroup(targetGroupName);
            if (this.groupManager.listLocalGroups().isEmpty()) {
                this.joinGroup("default");
            }
        } else if (ManageGroupAction.PURGE.equals((Object)action)) {
            this.purgeGroups();
            this.joinGroup("default");
        } else if (ManageGroupAction.SET.equals((Object)action)) {
            Group localGroup = this.groupManager.listLocalGroups().iterator().next();
            this.quitGroup(localGroup.getName());
            this.joinGroup(targetGroupName);
        }
        this.addGroupListToResult(result);
        return result;
    }

    public void addGroupListToResult(ManageGroupResult result) {
        Set<Group> groups = this.groupManager.listAllGroups();
        for (Group g : groups) {
            if (g.getName() == null || g.getName().isEmpty()) continue;
            result.getGroups().add(g);
        }
    }

    public void joinGroup(String targetGroupName) {
        Node node = this.clusterManager.getNode();
        Map<String, Group> groups = this.groupManager.listGroups();
        if (groups != null && !groups.isEmpty()) {
            Group targetGroup = groups.get(targetGroupName);
            if (targetGroup == null) {
                this.groupManager.registerGroup(targetGroupName);
            } else if (!targetGroup.getNodes().contains(node)) {
                targetGroup.getNodes().add(node);
                this.groupManager.listGroups().put(targetGroupName, targetGroup);
                this.groupManager.registerGroup(targetGroup);
            }
        }
    }

    public void quitGroup(String targetGroupName) {
        Group targetGroup;
        Node node = this.clusterManager.getNode();
        Map<String, Group> groups = this.groupManager.listGroups();
        if (groups != null && !groups.isEmpty() && (targetGroup = groups.get(targetGroupName)).getNodes().contains(node)) {
            targetGroup.getNodes().remove(node);
            this.groupManager.unRegisterGroup(targetGroup);
        }
    }

    public void purgeGroups() {
        Node node = this.clusterManager.getNode();
        Set<String> groupNames = this.groupManager.listGroupNames(node);
        if (groupNames != null && !groupNames.isEmpty()) {
            for (String targetGroupName : groupNames) {
                this.quitGroup(targetGroupName);
            }
        }
    }

    @Override
    public Class<ManageGroupCommand> getType() {
        return ManageGroupCommand.class;
    }

    @Override
    public Switch getSwitch() {
        return this.commandSwitch;
    }
}

