/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.rest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.router.api.ImportConfiguration;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.apache.unomi.router.rest.AbstractConfigurationServiceEndpoint;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/importConfiguration")
@Component(service={ImportConfigurationServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class ImportConfigurationServiceEndPoint
extends AbstractConfigurationServiceEndpoint<ImportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger((String)ImportConfigurationServiceEndPoint.class.getName());
    @Reference
    protected ConfigSharingService configSharingService;

    @WebMethod(exclude=true)
    public void setConfigSharingService(ConfigSharingService configSharingService) {
        this.configSharingService = configSharingService;
    }

    public ImportConfigurationServiceEndPoint() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        logger.info("Initializing import configuration service endpoint...");
    }

    @WebMethod(exclude=true)
    @Reference(target="(configDiscriminator=IMPORT)")
    public void setImportConfigurationService(ImportExportConfigurationService<ImportConfiguration> importConfigurationService) {
        this.configurationService = importConfigurationService;
    }

    @Override
    public ImportConfiguration saveConfiguration(ImportConfiguration importConfiguration) {
        ImportConfiguration importConfigSaved = (ImportConfiguration)this.configurationService.save((Object)importConfiguration, true);
        return importConfigSaved;
    }

    @Override
    public void deleteConfiguration(String configId) {
        this.configurationService.delete(configId);
    }

    @POST
    @Path(value="/oneshot")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response processOneshotImportConfigurationCSV(@Multipart(value="importConfigId") String importConfigId, @Multipart(value="file") Attachment file) {
        try {
            java.nio.file.Path path = Paths.get(this.configSharingService.getProperty("oneshotImportUploadDir") + importConfigId + ".csv", new String[0]);
            Files.deleteIfExists(path);
            InputStream in = (InputStream)file.getObject(InputStream.class);
            Files.copy(in, path, new CopyOption[0]);
        }
        catch (IOException e) {
            logger.error("Error processing one shot configuration CSV", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }
}

