/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.FetchResponse;

public class FetchRequest
extends AbstractRequest {
    public static final int CONSUMER_REPLICA_ID = -1;
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.FETCH.id);
    private static final String REPLICA_ID_KEY_NAME = "replica_id";
    private static final String MAX_WAIT_KEY_NAME = "max_wait_time";
    private static final String MIN_BYTES_KEY_NAME = "min_bytes";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String MAX_BYTES_KEY_NAME = "max_bytes";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String FETCH_OFFSET_KEY_NAME = "fetch_offset";
    public static final int DEFAULT_RESPONSE_MAX_BYTES = Integer.MAX_VALUE;
    private final int replicaId;
    private final int maxWait;
    private final int minBytes;
    private final int maxBytes;
    private final LinkedHashMap<TopicPartition, PartitionData> fetchData;

    @Deprecated
    public FetchRequest(int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
        this(2, -1, maxWait, minBytes, Integer.MAX_VALUE, new LinkedHashMap<TopicPartition, PartitionData>(fetchData));
    }

    public FetchRequest(int maxWait, int minBytes, int maxBytes, LinkedHashMap<TopicPartition, PartitionData> fetchData) {
        this(ProtoUtils.latestVersion(ApiKeys.FETCH.id), -1, maxWait, minBytes, maxBytes, fetchData);
    }

    @Deprecated
    public static FetchRequest fromReplica(int replicaId, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
        return new FetchRequest(2, replicaId, maxWait, minBytes, Integer.MAX_VALUE, new LinkedHashMap<TopicPartition, PartitionData>(fetchData));
    }

    public static FetchRequest fromReplica(int replicaId, int maxWait, int minBytes, int maxBytes, LinkedHashMap<TopicPartition, PartitionData> fetchData) {
        return new FetchRequest(ProtoUtils.latestVersion(ApiKeys.FETCH.id), replicaId, maxWait, minBytes, maxBytes, fetchData);
    }

    private FetchRequest(int version, int replicaId, int maxWait, int minBytes, int maxBytes, LinkedHashMap<TopicPartition, PartitionData> fetchData) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.FETCH.id, version)));
        List<TopicAndPartitionData<PartitionData>> topicsData = TopicAndPartitionData.batchByTopic(fetchData);
        this.struct.set(REPLICA_ID_KEY_NAME, (Object)replicaId);
        this.struct.set(MAX_WAIT_KEY_NAME, (Object)maxWait);
        this.struct.set(MIN_BYTES_KEY_NAME, (Object)minBytes);
        if (version >= 3) {
            this.struct.set(MAX_BYTES_KEY_NAME, (Object)maxBytes);
        }
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (TopicAndPartitionData<PartitionData> topicEntry : topicsData) {
            Struct topicData = this.struct.instance(TOPICS_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.topic);
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry partitionEntry : topicEntry.partitions.entrySet()) {
                PartitionData fetchPartitionData = (PartitionData)partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(FETCH_OFFSET_KEY_NAME, (Object)fetchPartitionData.offset);
                partitionData.set(MAX_BYTES_KEY_NAME, (Object)fetchPartitionData.maxBytes);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
        this.replicaId = replicaId;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
        this.fetchData = fetchData;
    }

    public FetchRequest(Struct struct) {
        super(struct);
        this.replicaId = struct.getInt(REPLICA_ID_KEY_NAME);
        this.maxWait = struct.getInt(MAX_WAIT_KEY_NAME);
        this.minBytes = struct.getInt(MIN_BYTES_KEY_NAME);
        this.maxBytes = struct.hasField(MAX_BYTES_KEY_NAME) ? struct.getInt(MAX_BYTES_KEY_NAME) : Integer.MAX_VALUE;
        this.fetchData = new LinkedHashMap();
        for (Object topicResponseObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.getInt(PARTITION_KEY_NAME);
                long offset = partitionResponse.getLong(FETCH_OFFSET_KEY_NAME);
                int maxBytes = partitionResponse.getInt(MAX_BYTES_KEY_NAME);
                PartitionData partitionData = new PartitionData(offset, maxBytes);
                this.fetchData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, PartitionData> entry : this.fetchData.entrySet()) {
            FetchResponse.PartitionData partitionResponse = new FetchResponse.PartitionData(Errors.forException(e).code(), -1L, FetchResponse.EMPTY_RECORD_SET);
            responseData.put(entry.getKey(), partitionResponse);
        }
        switch (versionId) {
            case 0: {
                return new FetchResponse(responseData);
            }
            case 1: 
            case 2: 
            case 3: {
                return new FetchResponse((Map<TopicPartition, FetchResponse.PartitionData>)responseData, 0);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.FETCH.id)));
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int maxWait() {
        return this.maxWait;
    }

    public int minBytes() {
        return this.minBytes;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public Map<TopicPartition, PartitionData> fetchData() {
        return this.fetchData;
    }

    public static FetchRequest parse(ByteBuffer buffer, int versionId) {
        return new FetchRequest(ProtoUtils.parseRequest(ApiKeys.FETCH.id, versionId, buffer));
    }

    public static FetchRequest parse(ByteBuffer buffer) {
        return new FetchRequest(CURRENT_SCHEMA.read(buffer));
    }

    static final class TopicAndPartitionData<T> {
        public final String topic;
        public final LinkedHashMap<Integer, T> partitions;

        public TopicAndPartitionData(String topic) {
            this.topic = topic;
            this.partitions = new LinkedHashMap();
        }

        public static <T> List<TopicAndPartitionData<T>> batchByTopic(LinkedHashMap<TopicPartition, T> data) {
            ArrayList<TopicAndPartitionData<T>> topics = new ArrayList<TopicAndPartitionData<T>>();
            for (Map.Entry<TopicPartition, T> topicEntry : data.entrySet()) {
                String topic = topicEntry.getKey().topic();
                int partition = topicEntry.getKey().partition();
                T partitionData = topicEntry.getValue();
                if (topics.isEmpty() || !((TopicAndPartitionData)topics.get((int)(topics.size() - 1))).topic.equals(topic)) {
                    topics.add(new TopicAndPartitionData<T>(topic));
                }
                ((TopicAndPartitionData)topics.get((int)(topics.size() - 1))).partitions.put(partition, partitionData);
            }
            return topics;
        }
    }

    public static final class PartitionData {
        public final long offset;
        public final int maxBytes;

        public PartitionData(long offset, int maxBytes) {
            this.offset = offset;
            this.maxBytes = maxBytes;
        }
    }
}

