/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.request.useragent;

import nl.basjes.parse.useragent.PackagedRules;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import nl.basjes.parse.useragent.config.ConfigLoader;
import org.apache.unomi.plugins.request.useragent.UserAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentDetectorServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger((String)UserAgentDetectorServiceImpl.class.getName());
    private UserAgentAnalyzer userAgentAnalyzer;

    public void postConstruct() {
        UserAgentAnalyzer.UserAgentAnalyzerBuilder userAgentAnalyzerBuilder = (UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).immediateInitialization();
        userAgentAnalyzerBuilder.dropDefaultResources();
        for (String ruleFileName : PackagedRules.getRuleFileNames()) {
            if (ConfigLoader.isTestRulesOnlyFile((String)ruleFileName)) continue;
            userAgentAnalyzerBuilder.addResources("classpath*:" + ruleFileName);
        }
        if (this.getCurrentJVMMajorVersion() < 11) {
            logger.info("Use JVM 8 compliant version of the agent analyzer caching");
            userAgentAnalyzerBuilder.useJava8CompatibleCaching();
        }
        this.userAgentAnalyzer = (UserAgentAnalyzer)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)userAgentAnalyzerBuilder.withCache(10000)).withField("OperatingSystemClass")).withField("OperatingSystemName")).withField("AgentName")).withField("AgentVersion")).withField("DeviceClass")).withField("DeviceName")).withField("DeviceBrand")).build();
        this.userAgentAnalyzer.initializeMatchers();
        logger.info("UserAgentDetector service initialized.");
    }

    private int getCurrentJVMMajorVersion() {
        String[] versionElements = System.getProperty("java.version").split("\\.");
        int discard = Integer.parseInt(versionElements[0]);
        if (discard == 1) {
            return Integer.parseInt(versionElements[1]);
        }
        return discard;
    }

    public void preDestroy() {
        if (this.userAgentAnalyzer != null) {
            this.userAgentAnalyzer.destroy();
            this.userAgentAnalyzer = null;
        }
        logger.info("UserAgentDetector service shutdown.");
    }

    public UserAgent parseUserAgent(String header) {
        UserAgent.ImmutableUserAgent yauaaAgent = this.userAgentAnalyzer.parse(header);
        UserAgent userAgent = new UserAgent();
        userAgent.setDeviceCategory(yauaaAgent.getValue("DeviceClass"));
        userAgent.setDeviceName(yauaaAgent.getValue("DeviceName"));
        userAgent.setDeviceBrand(yauaaAgent.getValue("DeviceBrand"));
        userAgent.setOperatingSystemFamily(yauaaAgent.getValue("OperatingSystemClass"));
        userAgent.setOperatingSystemName(yauaaAgent.getValue("OperatingSystemName"));
        userAgent.setUserAgentName(yauaaAgent.getValue("AgentName"));
        userAgent.setUserAgentVersion(yauaaAgent.getValue("AgentVersion"));
        if (logger.isDebugEnabled()) {
            logger.debug(userAgent.toString());
        }
        return userAgent;
    }
}

