/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.RunSession;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.help.instructions.BuilderInstructions;
import aQute.bnd.help.instructions.LauncherInstructions;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.Strategy;
import aQute.bnd.stream.MapStream;
import aQute.lib.io.IO;
import aQute.lib.watcher.FileWatcher;
import aQute.libg.command.Command;
import aQute.libg.generics.Create;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProjectLauncher
extends Processor {
    public static final String EMBEDDED_ACTIVATOR = "Embedded-Activator";
    static final Logger logger = LoggerFactory.getLogger(ProjectLauncher.class);
    private final Project project;
    private final List<Runnable> onUpdate = new ArrayList<Runnable>();
    private long timeout = 0L;
    private final List<String> classpath = new ArrayList<String>();
    private List<String> runbundles = Create.list();
    private final List<String> runvm = new ArrayList<String>();
    private final List<String> runprogramargs = new ArrayList<String>();
    private boolean runframeworkrestart;
    private Map<String, String> runproperties;
    private Command java;
    private Parameters runsystempackages;
    private Parameters runsystemcapabilities;
    private final List<String> activators = Create.list();
    private File storageDir;
    protected BuilderInstructions builderInstrs;
    protected LauncherInstructions launcherInstrs;
    private boolean trace;
    private boolean keep;
    private int framework;
    private File cwd;
    private Collection<String> agents = new ArrayList<String>();
    private Set<NotificationListener> listeners = Collections.newSetFromMap(new IdentityHashMap());
    protected Appendable out = System.out;
    protected Appendable err = System.err;
    protected InputStream in = System.in;
    public static final int SERVICES = 10111;
    public static final int NONE = 20123;
    public static final int OK = 0;
    public static final int WARNING = 125;
    public static final int ERROR = 124;
    public static final int TIMEDOUT = 123;
    public static final int UPDATE_NEEDED = 122;
    public static final int CANCELED = 121;
    public static final int DUPLICATE_BUNDLE = 120;
    public static final int RESOLVE_ERROR = 119;
    public static final int ACTIVATOR_ERROR = 118;
    public static final int STOPPED = 117;
    static final Pattern IGNORE = Pattern.compile("org[./]osgi[./]resource.*");

    public ProjectLauncher(Project project) throws Exception {
        this.project = project;
        this.setBase(project.getBase());
        this.builderInstrs = project.getInstructions(BuilderInstructions.class);
        this.launcherInstrs = project.getInstructions(LauncherInstructions.class);
        this.validate();
    }

    protected void validate() {
        Collection<String> runvm = this.getRunVM();
        if (runvm.size() == 1) {
            try {
                for (String r : runvm) {
                    if (!Verifier.isSpaceSeparated(r)) continue;
                    Reporter.SetLocation location = this.project.warning("%s is a comma (,) separated instruction, it looks like you separate its values with spaces? If you need spaces, please quote them: %s", "-runvm", runvm);
                    this.project.getHeader("-runvm").set(location);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void updateFromProject() throws Exception {
        File[] builds;
        this.setCwd(this.getProject().getBase());
        this.runbundles.clear();
        Collection<Container> run = this.getProject().getRunbundles();
        for (Container container : run) {
            File file = container.getFile();
            if (file != null && (file.isFile() || file.isDirectory())) {
                this.addRunBundle(IO.absolutePath(file));
                continue;
            }
            this.getProject().error("Bundle file \"%s\" does not exist, given error is %s", file, container.getError());
        }
        if (this.getProject().getRunBuilds() && (builds = this.getProject().getBuildFiles(true)) != null) {
            for (File file : builds) {
                this.addRunBundle(IO.absolutePath(file));
            }
        }
        Collection<Container> runpath = this.getProject().getRunpath();
        this.runsystempackages = new Parameters(this.getProject().mergeProperties("-runsystempackages"), this.getProject());
        this.runsystemcapabilities = new Parameters(this.getProject().mergeProperties("-runsystemcapabilities"), this.getProject());
        this.framework = this.getRunframework(this.getProject().getProperty("-runframework"));
        this.timeout = Processor.getDuration(this.getProject().getProperty("-runtimeout"), 0L);
        this.trace = this.getProject().isRunTrace();
        runpath.addAll(this.getProject().getRunFw());
        for (Container c : runpath) {
            this.addClasspath(c);
        }
        this.runvm.addAll(this.getProject().getRunVM());
        this.runprogramargs.addAll(this.getProject().getRunProgramArgs());
        this.runproperties = this.getProject().getRunProperties();
        this.runframeworkrestart = ProjectLauncher.isTrue(this.getProject().getProperty("-runframeworkrestart"));
        this.storageDir = this.getProject().getRunStorage();
        this.setKeep(this.getProject().getRunKeep());
        this.calculatedProperties(this.runproperties);
    }

    private int getRunframework(String property) {
        if ("none".equalsIgnoreCase(property)) {
            return 20123;
        }
        if ("services".equalsIgnoreCase(property)) {
            return 10111;
        }
        return 10111;
    }

    public void addClasspath(Container container) throws Exception {
        this.addClasspath(container, this.classpath);
    }

    protected void addClasspath(Container container, List<String> pathlist) throws Exception {
        if (container.getError() != null) {
            this.getProject().error("Cannot launch because %s has reported %s", container.getProject(), container.getError());
        } else {
            List<Container> members = container.getMembers();
            for (Container m : members) {
                String path = IO.absolutePath(m.getFile());
                if (pathlist.contains(path)) continue;
                Manifest manifest = m.getManifest();
                if (manifest != null) {
                    String agentClassName = manifest.getMainAttributes().getValue("Premain-Class");
                    if (agentClassName != null) {
                        String agent = path;
                        if (container.getAttributes().get("agent") != null) {
                            agent = agent + "=" + container.getAttributes().get("agent");
                        }
                        this.agents.add(agent);
                    }
                    Parameters exports = this.getProject().parseHeader(manifest.getMainAttributes().getValue("Export-Package"));
                    for (Map.Entry<String, Attrs> e : exports.entrySet()) {
                        if (this.runsystempackages.containsKey(e.getKey())) continue;
                        this.runsystempackages.put(e.getKey(), e.getValue());
                    }
                    String activator = manifest.getMainAttributes().getValue(EMBEDDED_ACTIVATOR);
                    if (activator != null) {
                        this.activators.add(activator);
                    }
                }
                pathlist.add(path);
            }
        }
    }

    protected void addClasspath(Collection<Container> path) throws Exception {
        for (Container c : Container.flatten(path)) {
            this.addClasspath(c);
        }
    }

    public void addRunBundle(String path) {
        if (!this.runbundles.contains(path = IO.normalizePath(path))) {
            this.runbundles.add(path);
        }
    }

    public Collection<String> getRunBundles() {
        return this.runbundles;
    }

    public void addRunVM(String arg) {
        this.runvm.add(arg);
    }

    public void addRunProgramArgs(String arg) {
        this.runprogramargs.add(arg);
    }

    public List<String> getRunpath() {
        return this.classpath;
    }

    public Collection<String> getClasspath() {
        return this.classpath;
    }

    public Collection<String> getRunVM() {
        return this.runvm;
    }

    @Deprecated
    public Collection<String> getArguments() {
        return this.getRunProgramArgs();
    }

    public Collection<String> getRunProgramArgs() {
        return this.runprogramargs;
    }

    public Map<String, String> getRunProperties() {
        return this.runproperties;
    }

    public File getStorageDir() {
        return this.storageDir;
    }

    public abstract String getMainTypeName();

    public void update() throws Exception {
        this.getProject().refresh();
        this.updateFromProject();
        for (Runnable update : this.onUpdate) {
            update.run();
        }
    }

    public void onUpdate(Runnable update) {
        this.onUpdate.add(update);
    }

    @Override
    public String getJavaExecutable(String java) {
        return this.getProject().getJavaExecutable(java);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int launch() throws Exception {
        File cwd;
        String jdb;
        this.prepare();
        this.java = new Command();
        MapStream.of(this.getRunEnv()).forEachOrdered(this.java::var);
        this.java.add(this.getJavaExecutable("java"));
        if (this.getProject().is("-javaagent")) {
            for (String agent : this.agents) {
                this.java.add("-javaagent:" + agent);
            }
        }
        if ((jdb = this.getRunJdb()) != null) {
            int port = 1044;
            try {
                port = Integer.parseInt(jdb);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String suspend = port > 0 ? "y" : "n";
            this.java.add("-Xrunjdwp:server=y,transport=dt_socket,address=" + Math.abs(port) + ",suspend=" + suspend);
        }
        this.java.addAll(ProjectLauncher.split(System.getenv("JAVA_OPTS"), "\\s+"));
        this.java.add("-cp");
        this.java.add(ProjectLauncher.join(this.getClasspath(), File.pathSeparator));
        this.java.addAll(this.getRunVM());
        this.java.add(this.getMainTypeName());
        this.java.addAll(this.getRunProgramArgs());
        if (this.getTimeout() != 0L) {
            this.java.setTimeout(this.getTimeout() + 1000L, TimeUnit.MILLISECONDS);
        }
        if ((cwd = this.getCwd()) != null) {
            this.java.setCwd(cwd);
        }
        logger.debug("cmd line {}", (Object)this.java);
        try {
            int result = this.java.execute(this.in, this.out, this.err);
            if (result == Integer.MIN_VALUE) {
                int n = 123;
                return n;
            }
            this.reportResult(result);
            int n = result;
            return n;
        }
        finally {
            this.cleanup();
            this.listeners.clear();
        }
    }

    public int start(ClassLoader parent) throws Exception {
        this.prepare();
        ClassLoader fcl = new ClassLoader(parent){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (IGNORE.matcher(name).matches()) {
                    throw new ClassNotFoundException();
                }
                return super.loadClass(name, resolve);
            }
        };
        ArrayList<URL> cp = new ArrayList<URL>();
        for (String path : this.getRunpath()) {
            cp.add(new File(path).toURI().toURL());
        }
        URLClassLoader cl = new URLClassLoader(cp.toArray(new URL[0]), fcl){

            @Override
            public void addURL(URL url) {
                super.addURL(url);
            }
        };
        String[] args = this.getRunProgramArgs().toArray(new String[0]);
        Class<?> main = cl.loadClass(this.getMainTypeName());
        return this.invoke(main, args);
    }

    protected int invoke(Class<?> main, String[] args) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void cleanup() {
    }

    protected void reportResult(int result) {
        switch (result) {
            case 0: {
                logger.debug("Command terminated normal {}", (Object)this.java);
                break;
            }
            case 123: {
                this.getProject().error("Launch timedout: %s", this.java);
                break;
            }
            case 124: {
                this.getProject().error("Launch errored: %s", this.java);
                break;
            }
            case 125: {
                this.getProject().warning("Launch had a warning %s", this.java);
                break;
            }
            default: {
                this.getProject().error("Exit code remote process %d: %s", result, this.java);
            }
        }
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = unit.convert(timeout, TimeUnit.MILLISECONDS);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void cancel() throws Exception {
        this.java.cancel();
    }

    public Map<String, ? extends Map<String, String>> getSystemPackages() {
        return this.runsystempackages.asMapMap();
    }

    public String getSystemCapabilities() {
        return this.runsystemcapabilities.isEmpty() ? null : this.runsystemcapabilities.toString();
    }

    public Parameters getSystemCapabilitiesParameters() {
        return this.runsystemcapabilities;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public boolean isKeep() {
        return this.keep;
    }

    @Override
    public void setTrace(boolean level) {
        this.trace = level;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void prepare() throws Exception {
    }

    public Project getProject() {
        return this.project;
    }

    public boolean addActivator(String e) {
        return this.activators.add(e);
    }

    public Collection<String> getActivators() {
        return Collections.unmodifiableCollection(this.activators);
    }

    public int getRunFramework() {
        return this.framework;
    }

    public void setRunFramework(int n) {
        assert (n == 20123 || n == 10111);
        this.framework = n;
    }

    public void addDefault(String defaultSpec) throws Exception {
        List<Container> deflts = this.getProject().getBundles(Strategy.HIGHEST, defaultSpec, null);
        for (Container c : deflts) {
            this.addClasspath(c);
        }
    }

    public Jar executable() throws Exception {
        throw new UnsupportedOperationException();
    }

    public File getCwd() {
        return this.cwd;
    }

    public void setCwd(File cwd) {
        this.cwd = cwd;
    }

    public String getRunJdb() {
        return this.getProject().getProperty("-runjdb");
    }

    public Map<String, String> getRunEnv() {
        String runenv = this.getProject().getProperty("-runenv");
        if (runenv != null) {
            return OSGiHeader.parseProperties(runenv);
        }
        return Collections.emptyMap();
    }

    public void registerForNotifications(NotificationListener listener) {
        this.listeners.add(listener);
    }

    public Set<NotificationListener> getNotificationListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public void setStreams(Appendable out, Appendable err) {
        this.out = out;
        this.err = err;
    }

    public void write(String text) throws Exception {
    }

    public List<? extends RunSession> getRunSessions() throws Exception {
        return null;
    }

    public void calculatedProperties(Map<String, String> properties) throws Exception {
        Collection<String> activators;
        boolean eager;
        if (this.getTrace()) {
            properties.put("launch.trace", "true");
        }
        if (eager = this.launcherInstrs.runoptions().contains((Object)LauncherInstructions.RunOption.eager)) {
            properties.put("launch.activation.eager", Boolean.toString(eager));
        }
        if (!(activators = this.getActivators()).isEmpty()) {
            properties.put("launch.activators", ProjectLauncher.join(activators, ","));
        }
        if (!this.keep) {
            properties.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        if (!this.runsystemcapabilities.isEmpty()) {
            properties.put("org.osgi.framework.system.capabilities.extra", this.runsystemcapabilities.toString());
        }
        if (!this.runsystempackages.isEmpty()) {
            properties.put("org.osgi.framework.system.packages.extra", this.runsystempackages.toString());
        }
        this.setupStartlevels(properties);
    }

    private void setupStartlevels(Map<String, String> properties) throws Exception, IOException {
        Parameters runbundles = new Parameters();
        int maxLevel = -1;
        for (Container c : this.project.getRunbundles()) {
            Map<String, String> attrs = c.getAttributes();
            if (attrs == null || c.getBundleSymbolicName() == null || c.getError() != null || c.getFile() == null || !c.getFile().isFile()) continue;
            Attrs runtimeAttrs = attrs instanceof Attrs ? new Attrs((Attrs)attrs) : new Attrs(attrs);
            String startLevelString = attrs.get("startlevel");
            if (startLevelString == null) continue;
            int startlevel = -1;
            if (!Verifier.isNumber(startLevelString)) {
                this.error("Invalid start level on -runbundles. bsn=%s, version=%s, startlevel=%s, not a number", c.getBundleSymbolicName(), c.getVersion(), startLevelString);
                continue;
            }
            startlevel = Integer.parseInt(startLevelString);
            if (startlevel > 0 && startlevel > maxLevel) {
                maxLevel = startlevel;
            }
            Domain domain = Domain.domain(c.getFile());
            String bsn = domain.getBundleSymbolicName().getKey();
            String bundleVersion = domain.getBundleVersion();
            if (!Verifier.isVersion(bundleVersion)) {
                this.error("Invalid version on -runbundles. bsn=%s, version=%s", c.getBundleSymbolicName(), c.getVersion(), startLevelString);
                continue;
            }
            runtimeAttrs.put("version", bundleVersion);
            runbundles.put(bsn, runtimeAttrs);
        }
        boolean areStartlevelsEnabled = maxLevel > 0;
        String beginningLevelString = properties.get("org.osgi.framework.startlevel.beginning");
        if (!runbundles.isEmpty()) {
            properties.put("launch.runbundles.attrs", runbundles.toString());
            if (areStartlevelsEnabled) {
                int defaultLevel = maxLevel + 1;
                int beginningLevel = maxLevel + 2;
                if (!properties.containsKey("launch.startlevel.default")) {
                    properties.put("launch.startlevel.default", Integer.toString(defaultLevel));
                }
                if (beginningLevelString == null) {
                    properties.put("org.osgi.framework.startlevel.beginning", Integer.toString(beginningLevel));
                }
            }
        }
        if (beginningLevelString != null) {
            if (!Verifier.isNumber(beginningLevelString)) {
                this.error("%s set to %s, not a valid startlevel (is not a number)", beginningLevelString);
            } else {
                int beginningStartLevel = Integer.parseInt(beginningLevelString);
                if (beginningStartLevel < 1) {
                    this.error("%s set to %s, must be > 0", beginningLevelString);
                }
            }
        }
    }

    public LiveCoding liveCoding(Executor executor, ScheduledExecutorService scheduledExecutor) throws Exception {
        return new LiveCoding(executor, scheduledExecutor);
    }

    public boolean isRunFrameworkRestart() {
        return this.runframeworkrestart;
    }

    public class LiveCoding
    implements Closeable {
        private final Semaphore semaphore = new Semaphore(1);
        private final AtomicBoolean propertiesChanged = new AtomicBoolean(false);
        private final Executor executor;
        private final ScheduledExecutorService scheduledExecutor;
        private volatile FileWatcher fw;

        LiveCoding(Executor executor, ScheduledExecutorService scheduledExecutor) throws Exception {
            this.executor = Objects.requireNonNull(executor);
            this.scheduledExecutor = Objects.requireNonNull(scheduledExecutor);
            this.watch();
        }

        @Override
        public void close() {
            FileWatcher old = this.fw;
            if (old != null) {
                old.close();
            }
        }

        private void watch() throws IOException {
            FileWatcher.Builder builder = new FileWatcher.Builder().executor(this.executor).changed(this::changed).file(ProjectLauncher.this.getProject().getPropertiesFile()).files(ProjectLauncher.this.getProject().getIncluded());
            for (String runpath : ProjectLauncher.this.getRunpath()) {
                builder.file(new File(runpath));
            }
            for (String runbundle : ProjectLauncher.this.getRunBundles()) {
                builder.file(new File(runbundle));
            }
            FileWatcher old = this.fw;
            this.fw = builder.build();
            if (old != null) {
                old.close();
            }
            logger.debug("[LiveCoding] Watching for changes...");
        }

        private void changed(File file, String kind) {
            logger.info("[LiveCoding] Detected change to {}.", (Object)file);
            this.propertiesChanged.compareAndSet(false, ProjectLauncher.this.getProject().getPropertiesFile().equals(file) || ProjectLauncher.this.getProject().getIncluded().contains(file));
            if (this.semaphore.tryAcquire()) {
                this.scheduledExecutor.schedule(() -> {
                    try {
                        logger.info("[LiveCoding] Updating ProjectLauncher.");
                        ProjectLauncher.this.update();
                    }
                    catch (Exception e) {
                        logger.error("[LiveCoding] Error on ProjectLauncher update", (Throwable)e);
                    }
                    finally {
                        this.semaphore.release();
                        if (this.propertiesChanged.compareAndSet(true, false)) {
                            logger.info("[LiveCoding] Detected changes to bnd properties file. Replacing watcher.");
                            try {
                                this.watch();
                            }
                            catch (IOException e) {
                                logger.error("[LiveCoding] Error replacing watcher {}", (Throwable)e);
                            }
                        }
                    }
                }, 600L, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static enum NotificationType {
        ERROR,
        WARNING,
        INFO;

    }

    public static interface NotificationListener {
        public void notify(NotificationType var1, String var2);
    }
}

