/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features;

import java.util.EnumSet;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.features.ClusterFeaturesEvent;
import org.apache.karaf.cellar.features.FeaturesSupport;
import org.apache.karaf.cellar.features.FeaturesSynchronizer;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesEventHandler
extends FeaturesSupport
implements EventHandler<ClusterFeaturesEvent> {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(FeaturesSynchronizer.class);
    public static final String SWITCH_ID = "org.apache.karaf.cellar.event.features.handler";
    private final Switch eventSwitch = new BasicSwitch("org.apache.karaf.cellar.event.features.handler");

    @Override
    public void init(BundleContext bundleContext) {
        super.init(bundleContext);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handle(ClusterFeaturesEvent event) {
        block17: {
            if (this.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
                LOGGER.debug("CELLAR FEATURE: {} switch is OFF, cluster event is not handled", (Object)SWITCH_ID);
                return;
            }
            if (this.groupManager == null) {
                LOGGER.error("CELLAR FEATURE: retrieved event {} while groupManager is not available yet!", (Object)event);
                return;
            }
            if (!this.groupManager.isLocalGroup(event.getSourceGroup().getName())) {
                LOGGER.debug("CELLAR FEATURE: node is not part of the event cluster group {}", (Object)event.getSourceGroup().getName());
                return;
            }
            if (event.getLocal() != null && event.getLocal().getId().equalsIgnoreCase(this.clusterManager.getNode().getId())) {
                LOGGER.trace("CELLAR FEATURE: cluster event is local (coming from local synchronizer or listener)");
                return;
            }
            String name = event.getName();
            String version = event.getVersion();
            if (this.isAllowed(event.getSourceGroup(), "feature", name, EventType.INBOUND).booleanValue() || event.getForce().booleanValue()) {
                FeatureEvent.EventType type = event.getType();
                Boolean isInstalled = this.isFeatureInstalledLocally(name, version);
                try {
                    if (FeatureEvent.EventType.FeatureInstalled.equals((Object)type)) {
                        boolean noRefresh = event.getNoRefresh();
                        boolean noStart = event.getNoStart();
                        boolean noManage = event.getNoManage();
                        boolean upgrade = event.getUpgrade();
                        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
                        if (noRefresh) {
                            options.add(FeaturesService.Option.NoAutoRefreshBundles);
                        }
                        if (noStart) {
                            options.add(FeaturesService.Option.NoAutoStartBundles);
                        }
                        if (noManage) {
                            options.add(FeaturesService.Option.NoAutoManageBundles);
                        }
                        if (upgrade) {
                            options.add(FeaturesService.Option.Upgrade);
                        }
                        if (version != null) {
                            LOGGER.debug("CELLAR FEATURE: installing feature {}/{}", (Object)name, (Object)version);
                            this.featuresService.installFeature(name, version, options);
                        } else {
                            LOGGER.debug("CELLAR FEATURE: installing feature {}", (Object)name);
                            this.featuresService.installFeature(name, options);
                        }
                        break block17;
                    }
                    if (!FeatureEvent.EventType.FeatureUninstalled.equals((Object)type) || !isInstalled.booleanValue()) break block17;
                    boolean noRefresh = event.getNoRefresh();
                    EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
                    if (noRefresh) {
                        options.add(FeaturesService.Option.NoAutoRefreshBundles);
                    }
                    if (version != null) {
                        LOGGER.debug("CELLAR FEATURE: uninstalling feature {}/{}", (Object)name, (Object)version);
                        this.featuresService.uninstallFeature(name, version, options);
                        break block17;
                    }
                    LOGGER.debug("CELLAR FEATURE: uninstalling feature {}", (Object)name);
                    this.featuresService.uninstallFeature(name, options);
                }
                catch (Exception e) {
                    LOGGER.error("CELLAR FEATURE: failed to handle cluster feature event", (Throwable)e);
                }
            } else {
                LOGGER.trace("CELLAR FEATURE: feature {} is marked BLOCKED INBOUND for cluster group {}", (Object)name, (Object)event.getSourceGroup().getName());
            }
        }
    }

    public Class<ClusterFeaturesEvent> getType() {
        return ClusterFeaturesEvent.class;
    }

    public Switch getSwitch() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null) {
                Boolean status = new Boolean((String)configuration.getProperties().get("handler." + ((Object)((Object)this)).getClass().getName()));
                if (status.booleanValue()) {
                    this.eventSwitch.turnOn();
                } else {
                    this.eventSwitch.turnOff();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.eventSwitch;
    }
}

