/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.link;

import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.IO;
import aQute.lib.json.JSONCodec;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Link<L, R>
extends Thread
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(Link.class);
    static final String[] EMPTY = new String[0];
    static final JSONCodec codec = new JSONCodec();
    final DataInputStream in;
    final DataOutputStream out;
    final Class<R> remoteClass;
    final AtomicInteger id = new AtomicInteger(10000);
    final ConcurrentMap<Integer, Result> promises = new ConcurrentHashMap<Integer, Result>();
    final AtomicBoolean quit = new AtomicBoolean(false);
    final AtomicBoolean started = new AtomicBoolean(false);
    final Executor executor;
    volatile boolean transfer = false;
    private ThreadLocal<Integer> msgid = new ThreadLocal();
    R remote;
    L local;

    public Link(Class<R> remoteType, InputStream in, OutputStream out, Executor es) {
        this(remoteType, new DataInputStream(in), new DataOutputStream(out), es);
    }

    public Link(Class<R> remoteType, DataInputStream in, DataOutputStream out, Executor es) {
        super("link::" + remoteType.getName());
        this.setDaemon(true);
        this.remoteClass = remoteType;
        this.in = new DataInputStream(in);
        this.out = new DataOutputStream(out);
        this.executor = es;
    }

    public Link(Class<R> type, Socket socket, Executor es) throws IOException {
        this(type, socket.getInputStream(), socket.getOutputStream(), es);
    }

    public void open(L local) {
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Already running");
        }
        this.local = local;
        this.start();
    }

    @Override
    public void close() throws IOException {
        if (this.quit.getAndSet(true)) {
            return;
        }
        if (this.local instanceof Closeable) {
            try {
                ((Closeable)this.local).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.transfer) {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized R getRemote() {
        if (this.quit.get()) {
            return null;
        }
        if (this.remote == null) {
            this.remote = Proxy.newProxyInstance(this.remoteClass.getClassLoader(), new Class[]{this.remoteClass}, (target, method, args) -> {
                if (this.quit.get()) {
                    throw new IllegalStateException("Already closed");
                }
                Object hash = new Object();
                try {
                    int msgId;
                    if (method.getDeclaringClass() == Object.class) {
                        return method.invoke(hash, args);
                    }
                    try {
                        msgId = this.send(this.id.getAndIncrement(), method, args);
                        if (method.getReturnType() == Void.TYPE) {
                            this.promises.remove(msgId);
                            return null;
                        }
                    }
                    catch (Exception e1) {
                        this.terminate(e1);
                        throw e1;
                    }
                    return this.waitForResult(msgId, method.getGenericReturnType());
                }
                catch (InvocationTargetException e2) {
                    throw Exceptions.unrollCause(e2, InvocationTargetException.class);
                }
                catch (InterruptedException e3) {
                    this.interrupt();
                    throw e3;
                }
                catch (Exception e4) {
                    throw e4;
                }
            });
        }
        return this.remote;
    }

    @Override
    public void run() {
        while (!(this.isInterrupted() || this.transfer || this.quit.get())) {
            try {
                String cmd = this.in.readUTF();
                this.trace("rx " + cmd);
                int id = this.in.readInt();
                int count = this.in.readShort();
                ArrayList<byte[]> args = new ArrayList<byte[]>(count);
                for (int i = 0; i < count; ++i) {
                    int length = this.in.readInt();
                    byte[] data = new byte[length];
                    this.in.readFully(data);
                    args.add(data);
                }
                Runnable r = () -> {
                    try {
                        this.msgid.set(id);
                        this.executeCommand(cmd, id, args);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.msgid.set(-1);
                };
                this.executor.execute(r);
            }
            catch (SocketTimeoutException cmd) {
            }
            catch (Exception ee) {
                this.terminate(ee);
                return;
            }
        }
    }

    public static <L, R> Closeable server(String name, Class<R> type, int port, String host, Function<Link<L, R>, L> local, boolean localOnly, ExecutorService es) throws IOException {
        InetAddress addr = host == null ? InetAddress.getLocalHost() : (host.equals("*") ? null : InetAddress.getByName(host));
        ServerSocket server = host == null ? new ServerSocket(port) : new ServerSocket(port, 50, addr);
        return Link.server(name, type, server, local, localOnly, es);
    }

    public static <L, R> Closeable server(final String name, final Class<R> type, final ServerSocket server, final Function<Link<L, R>, L> local, final boolean localOnly, final Executor es) {
        try {
            final ArrayList links = new ArrayList();
            Thread t = new Thread(name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    block9: while (true) {
                        while (!this.isInterrupted()) {
                            try {
                                Socket socket = server.accept();
                                InetAddress remoteSocketAddress = socket.getInetAddress();
                                if (localOnly && !remoteSocketAddress.isLoopbackAddress() && !remoteSocketAddress.equals(InetAddress.getLocalHost())) {
                                    logger.error("Warning remote address is requested to be local but is {}", (Object)remoteSocketAddress);
                                    IO.close(socket);
                                    continue;
                                }
                                Link link = new Link(type, socket, es);
                                links.add(link);
                                logger.info("Created link {}", (Object)name);
                                link.open(local.apply(link));
                            }
                            catch (Exception e) {
                                if (this.isInterrupted()) {
                                    logger.info("Exiting link {}", (Object)name);
                                    IO.close(server);
                                    return;
                                }
                                logger.error("Error setting up link {}", (Object)name, (Object)e);
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e1) {
                                    this.interrupt();
                                    logger.info("Exiting link {}", (Object)name);
                                    IO.close(server);
                                    return;
                                }
                                try {
                                    continue block9;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                    return;
                                }
                            }
                        }
                        break;
                    }
                    finally {
                        logger.info("Exiting link {}", (Object)name);
                        IO.close(server);
                    }
                }
            };
            t.start();
            return () -> {
                logger.info("Closing link {}", (Object)name);
                t.interrupt();
                IO.close(server);
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                links.forEach(IO::close);
            };
        }
        catch (Exception e) {
            logger.error("Error setting up server socket link {}", (Object)name, (Object)e);
            throw Exceptions.duck(e);
        }
    }

    public boolean isOpen() {
        return !this.quit.get();
    }

    public DataOutputStream getOutput() {
        assert (this.transfer && !this.isOpen());
        return this.out;
    }

    public DataInputStream getInput() {
        assert (this.transfer && !this.isOpen());
        return this.in;
    }

    public void setRemote(Object remote) {
        this.remote = remote;
    }

    public void transfer(Object result) throws Exception {
        this.transfer = true;
        this.quit.set(true);
        this.interrupt();
        this.join();
        if (result != null) {
            this.send(this.msgid.get(), null, new Object[]{result});
        }
        this.close();
    }

    protected void terminate(Exception t) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Method getMethod(String cmd, int count) {
        for (Method m : this.local.getClass().getMethods()) {
            if (m.getDeclaringClass() == Link.class || !m.getName().equals(cmd) || m.getParameterTypes().length != count) continue;
            return m;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int send(int msgId, Method m, Object[] args) throws Exception {
        if (m != null) {
            this.promises.put(msgId, new Result());
        }
        this.trace("send");
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.writeUTF(m != null ? m.getName() : "");
            this.out.writeInt(msgId);
            if (args == null) {
                args = EMPTY;
            }
            this.out.writeShort(args.length);
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg instanceof byte[]) {
                    byte[] data = (byte[])arg;
                    this.out.writeInt(data.length);
                    this.out.write(data);
                    continue;
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                codec.enc().to(bout).put(arg);
                byte[] data = bout.toByteArray();
                this.out.writeInt(data.length);
                this.out.write(data);
            }
            this.out.flush();
            this.trace("sent");
        }
        return msgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void response(int msgId, byte[] data) {
        Result o;
        boolean exception = false;
        if (msgId < 0) {
            msgId = -msgId;
            exception = true;
        }
        if ((o = (Result)this.promises.get(msgId)) != null) {
            Result result = o;
            synchronized (result) {
                this.trace("resolved");
                o.value = data;
                o.exception = exception;
                o.resolved = true;
                o.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    <T> T waitForResult(int id, Type type) throws Exception {
        T t;
        long deadline = System.currentTimeMillis() + 300000L;
        Result result = (Result)this.promises.get(id);
        while (true) {
            Result result2 = result;
            // MONITORENTER : result2
            if (!result.resolved) break block13;
            if (result.value != null) break block14;
            t = null;
            // MONITOREXIT : result2
            break;
        }
        catch (Throwable throwable) {
            this.promises.remove(id);
            throw throwable;
        }
        {
            block13: {
                Object value;
                block14: {
                    this.promises.remove(id);
                    return t;
                }
                if (result.exception) {
                    String msg = codec.dec().from(result.value).get(String.class);
                    System.out.println("Exception " + msg);
                    throw new RuntimeException(msg);
                }
                if (type == byte[].class) {
                    byte[] msg = result.value;
                    // MONITOREXIT : result2
                    this.promises.remove(id);
                    return (T)msg;
                }
                Object object = value = codec.dec().from(result.value).get(type);
                // MONITOREXIT : result2
                this.promises.remove(id);
                return (T)object;
            }
            long delay = deadline - System.currentTimeMillis();
            if (delay <= 0L) {
                T t2 = null;
                // MONITOREXIT : result2
                this.promises.remove(id);
                return t2;
            }
            this.trace("start delay " + delay);
            result.wait(delay);
            this.trace("end delay " + (delay - (deadline - System.currentTimeMillis())));
            // MONITOREXIT : result2
            continue;
        }
    }

    private void trace(String string) {
        logger.trace("{}", (Object)string);
    }

    void executeCommand(String cmd, int id, List<byte[]> args) throws Exception {
        if (cmd.isEmpty()) {
            this.response(id, args.get(0));
        } else {
            Method m = this.getMethod(cmd, args.size());
            if (m == null) {
                return;
            }
            Object[] parameters = new Object[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                Class<?> type = m.getParameterTypes()[i];
                parameters[i] = type == byte[].class ? (Object)args.get(i) : codec.dec().from(args.get(i)).get(m.getGenericParameterTypes()[i]);
            }
            try {
                Object result = m.invoke(this.local, parameters);
                if (this.transfer || m.getReturnType() == Void.TYPE) {
                    return;
                }
                try {
                    this.send(id, null, new Object[]{result});
                }
                catch (Exception e) {
                    this.terminate(e);
                    throw e;
                }
            }
            catch (Throwable t) {
                t = Exceptions.unrollCause(t, InvocationTargetException.class);
                try {
                    this.send(-id, null, new Object[]{t + ""});
                }
                catch (Exception e) {
                    this.terminate(e);
                    throw e;
                }
            }
        }
    }

    static class Result {
        boolean resolved;
        byte[] value;
        public boolean exception;

        Result() {
        }
    }
}

