/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ops4j.pax.logging.PaxLogger;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class LogReaderServiceImpl
implements LogReaderService {
    private final List<LogListener> m_listeners = new CopyOnWriteArrayList<LogListener>();
    private final Deque<LogEntry> m_entries;
    private int m_maxEntries;
    private final PaxLogger m_logger;

    public LogReaderServiceImpl(int m_maxEntries, PaxLogger logger) {
        this.m_maxEntries = m_maxEntries;
        this.m_entries = new LinkedList<LogEntry>();
        this.m_logger = logger;
    }

    @Override
    public void addLogListener(LogListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void removeLogListener(LogListener listener) {
        this.m_listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration getLog() {
        Deque<LogEntry> deque = this.m_entries;
        synchronized (deque) {
            return Collections.enumeration(new ArrayList<LogEntry>(this.m_entries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(LogEntry entry) {
        Deque<LogEntry> deque = this.m_entries;
        synchronized (deque) {
            this.m_entries.addFirst(entry);
            this.cleanUp();
        }
        List<LogListener> listeners = this.m_listeners;
        for (LogListener listener : listeners) {
            this.fire(listener, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxEntries(int maxSize) {
        Deque<LogEntry> deque = this.m_entries;
        synchronized (deque) {
            this.m_maxEntries = maxSize;
        }
    }

    private void cleanUp() {
        while (this.m_entries.size() > this.m_maxEntries) {
            this.m_entries.removeLast();
        }
    }

    private void fire(LogListener listener, LogEntry entry) {
        block2: {
            try {
                listener.logged(entry);
            }
            catch (Throwable e) {
                if (this.m_logger == null) break block2;
                this.m_logger.error("'" + listener + "' is removed as a LogListener since it threw an exception.", e);
                this.removeLogListener(listener);
            }
        }
    }
}

