/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.HashMap;
import java.util.Map;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtendedHttpServiceRuntime;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.WebApplication;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ServletContextHelperElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.util.ServicePropertiesUtils;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultHttpContextMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextHelperTracker<T extends ServletContextHelper>
implements ServiceTrackerCustomizer<T, ServletContextHelperElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTracker.class);
    private final ExtenderContext extenderContext;
    private final BundleContext bundleContext;
    private final ExtendedHttpServiceRuntime httpServiceRuntime;

    private ServletContextHelperTracker(ExtenderContext extenderContext, BundleContext bundleContext, ExtendedHttpServiceRuntime httpServiceRuntime) {
        NullArgumentException.validateNotNull(extenderContext, "Extender context");
        this.extenderContext = extenderContext;
        this.bundleContext = ServletContextHelperTracker.validateBundleContext(bundleContext);
        this.httpServiceRuntime = httpServiceRuntime;
    }

    public final ServiceTracker<T, ServletContextHelperElement> create(Class<? extends T> trackedClass) {
        return new ServiceTracker(this.bundleContext, ServletContextHelperTracker.createFilter(this.bundleContext, trackedClass), (ServiceTrackerCustomizer)this);
    }

    public static <T extends ServletContextHelper> ServiceTracker<T, ServletContextHelperElement> createTracker(ExtenderContext extenderContext, BundleContext bundleContext, ExtendedHttpServiceRuntime httpServiceRuntime) {
        return new ServletContextHelperTracker<ServletContextHelper>(extenderContext, bundleContext, httpServiceRuntime).create(ServletContextHelper.class);
    }

    private static Filter createFilter(BundleContext bundleContext, Class<?> ... classes) {
        StringBuilder filter = new StringBuilder();
        if (classes != null) {
            if (classes.length > 1) {
                filter.append("(|");
            }
            for (Class<?> clazz : classes) {
                filter.append("(").append("objectClass").append("=").append(clazz.getName()).append(")");
            }
            if (classes.length > 1) {
                filter.append(")");
            }
        }
        try {
            return bundleContext.createFilter(filter.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    private static BundleContext validateBundleContext(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        return bundleContext;
    }

    public ServletContextHelperElement addingService(ServiceReference<T> serviceReference) {
        LOGGER.debug("ServletContextHelperService available " + serviceReference);
        ServletContextHelper registered = (ServletContextHelper)this.bundleContext.getService(serviceReference);
        String servletCtxtName = ServicePropertiesUtils.getStringProperty(serviceReference, "osgi.http.whiteboard.context.name");
        String ctxtPath = ServicePropertiesUtils.getStringProperty(serviceReference, "osgi.http.whiteboard.context.path");
        if (ctxtPath != null && ctxtPath.startsWith("/")) {
            ctxtPath = ctxtPath.substring(1);
        }
        DefaultHttpContextMapping mapping = new DefaultHttpContextMapping();
        mapping.setHttpContextId(servletCtxtName);
        mapping.setHttpContextShared(true);
        mapping.setPath(ctxtPath);
        Map<String, String> parameters = mapping.getParameters();
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        mapping.setParameters(parameters);
        parameters.put("httpContext.shared", "true");
        ServletContextHelperElement<ServletContextHelper> servletContextHelperElement = new ServletContextHelperElement<ServletContextHelper>(serviceReference, mapping, registered);
        if (servletContextHelperElement.isValid()) {
            WebApplication webApplication = this.extenderContext.getWebApplication(serviceReference.getBundle(), servletCtxtName, true);
            webApplication.setServletContextHelper(registered, mapping);
        }
        LOGGER.debug("Registering ServletContextHelper");
        this.httpServiceRuntime.addWhiteboardElement((WhiteboardElement)servletContextHelperElement);
        return servletContextHelperElement;
    }

    public void modifiedService(ServiceReference<T> reference, ServletContextHelperElement service) {
    }

    public void removedService(ServiceReference<T> serviceReference, ServletContextHelperElement unpublished) {
        LOGGER.debug("ServletContextHelperService removed " + serviceReference);
        if (unpublished.isValid()) {
            Boolean sharedHttpContext = ServicePropertiesUtils.extractSharedHttpContext(serviceReference);
            WebApplication webApplication = this.extenderContext.getExistingWebApplication(serviceReference.getBundle(), unpublished.getHttpContextMapping().getHttpContextId(), sharedHttpContext);
            boolean remove = true;
            if (sharedHttpContext.booleanValue()) {
                LOGGER.debug("Shared Context ... ");
                Integer sharedWebApplicationCounter = this.extenderContext.getSharedWebApplicationCounter(webApplication);
                LOGGER.debug("... counter:" + sharedWebApplicationCounter);
                if (sharedWebApplicationCounter != null && sharedWebApplicationCounter > 0) {
                    remove = false;
                    Integer reduceSharedWebApplicationCount = this.extenderContext.reduceSharedWebApplicationCount(webApplication);
                    LOGGER.debug("reduced counter:" + reduceSharedWebApplicationCount);
                    if (reduceSharedWebApplicationCount == 0) {
                        remove = true;
                    }
                }
            }
            if (webApplication != null && remove) {
                webApplication.setServletContextHelper(null, null);
            }
            this.httpServiceRuntime.removeWhiteboardElement((WhiteboardElement)unpublished);
        }
    }
}

